% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{power.mswR}
\alias{power.mswR}
\title{Power Calculation using the SWT-based Royston Test Statistic}
\usage{
power.mswR(a, n, p, B = 1000, FUN, ...)
}
\arguments{
\item{a}{significance level (\eqn{\alpha}).}

\item{n}{number of rows (observations).}

\item{p}{number of columns (variables), \eqn{n>p}.}

\item{B}{number of Monte Carlo simulations, default is 1000 (can increase B to increase the precision).}

\item{FUN}{self-defined function for generate multivariate distribution. See example.}

\item{...}{optional arguments passed to \code{FUN}.}
}
\value{
Returns a numeric value of the estimated empirical power (value between 0 and 1).
}
\description{
Empirical power calculation using Royston test statistic.
}
\examples{
set.seed(12345)

## Power calculation against bivariate (p=2) independent Beta(1, 1) distribution ##
## at sample size n=50 at one-sided alpha = 0.05 ##

power.mswR(a = 0.05, n = 50, p = 2,  B = 100, FUN=IMMV, D1=runif)

}
\references{
Royston, J. P. (1982). An extension of Shapiro and Wilk's W test for normality to large samples. \emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, 31(2), 115-124.
}
