% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvord.R
\docType{data}
\name{data_mvord_panel}
\alias{data_mvord_panel}
\title{Simulated panel of credit ratings}
\format{A data frame with 10000 rows and 9 variables}
\usage{
data(data_mvord_panel)
}
\description{
A simulated data set where one rater assigns ratings over the years \eqn{2001} to \eqn{2010} for a set of firms.
The IDs for each subject \eqn{i} of the \eqn{n = 1000} firms are stored in the column \code{firm_id}.
The year of the rating observation is stored in the column \code{year}.
The ordinal ratings are provided in the column \code{rating} and all the covariates in the remaining columns.
}
\details{
\itemize{
  \item \code{firm_id} firm index
  \item \code{year}  year index (2001 - 2010)
  \item \code{rating} ordinal credit ratings
  \item \code{X1} covariate X1
  \item \code{X2} covariate X2
  \item \code{X3} covariate X3
  \item \code{X4} covariate X4
  \item \code{X5} covariate X5
  \item \code{X6} covariate X6 (factor)
}
}
