% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StaPLR.R
\name{predict.StaPLR}
\alias{predict.StaPLR}
\title{Make predictions from a "StaPLR" object.}
\usage{
\method{predict}{StaPLR}(
  object,
  newx,
  newcf = NULL,
  predtype = "response",
  cvlambda = "lambda.min",
  ...
)
}
\arguments{
\item{object}{Fitted "StaPLR" model object.}

\item{newx}{Matrix of new values for x at which predictions are to be made. Must be a matrix.}

\item{newcf}{Matrix of new values of correction features, if correct.for was specified during model fitting.}

\item{predtype}{The type of prediction returned by the meta-learner.}

\item{cvlambda}{Values of the penalty parameters at which predictions are to be made. Defaults to the values giving minimum cross-validation error.}

\item{...}{Further arguments to be passed to \code{\link[glmnet]{predict.cv.glmnet}}.}
}
\value{
A matrix of predictions.
}
\description{
Make predictions from a "StaPLR" object.
}
\examples{
\donttest{ 
set.seed(012)
n <- 1000
cors <- seq(0.1,0.7,0.1)
X <- matrix(NA, nrow=n, ncol=length(cors)+1)
X[,1] <- rnorm(n)

for(i in 1:length(cors)){
  X[,i+1] <- X[,1]*cors[i] + rnorm(n, 0, sqrt(1-cors[i]^2))
}

beta <- c(1,0,0,0,0,0,0,0)
eta <- X \%*\% beta
p <- exp(eta)/(1+exp(eta))
y <- rbinom(n, 1, p)
view_index <- rep(1:(ncol(X)/2), each=2)

fit <- StaPLR(X, y, view_index)
coef(fit)$meta

new_X <- matrix(rnorm(16), nrow=2)
predict(fit, new_X)}
}
\author{
Wouter van Loon <w.s.van.loon@fsw.leidenuniv.nl>
}
\keyword{TBA}
