% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFunctions.R
\name{gammaBlur}
\alias{gammaBlur}
\title{Multichannel Gamma density blur}
\usage{
gammaBlur(n, shape, scale)
}
\arguments{
\item{n}{An integer specifying the number of observations in each channel.}

\item{shape}{A numeric vector of length m where each element specifies the shape parameter for the Gamma density used to blur each channel.}

\item{scale}{A numeric vector of length m where each element specifies the scale parameter for the Gamma density used to blur each channel.}
}
\value{
A numeric n by m matrix of normalised Gamma blur.
}
\description{
Create blur of the regular smooth type generated from Gamma densities
}
\details{
Function creates a matrix of dimension n by m which contains a normalised (unit energy in each column) set of blur functions of regular smooth type, generated by a Gamma density. These Gamma densities are generated using the \code{\link{dgamma}} base R function and then normalised to have unit energy.
}
\examples{
n <- 1024
m <- 3
shape <- seq(from = 0.5, to = 1, length = m)
scale <- rep(0.25,m)

# Plot the smooth (gamma) blur
x <- (1:n)/n
blurMat <- gammaBlur(n, shape, scale)
matplot(x, blurMat, type = 'l', main = paste('Set of Gamma', m,'Gamma blur densities.'))

# Plot a LIDAR signal and its multichannel smooth blurred version
signal <- makeLIDAR(n)
matplot(x, signal, type = 'l', main = 'LIDAR test signal')
blurredSignal <- blurSignal(signal, blurMat)
matplot(x, blurredSignal, type = 'l', main = 'Smooth blurred LIDAR test signals')
}
\seealso{
\code{\link{dgamma}} for details of the Gamma density

\code{\link{boxcarBlur}}, \code{\link{blurSignal}}
}

