/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.gmwcs.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.itmo.ctlab.gmwcs.solver.D;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;
import ru.itmo.ctlab.virgo.gmwcs.solver.MSTSolver;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b\u001a \u0010\f\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u001a\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0014"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "mapWeight", "", "w", "mergeEdges", "g", "Lru/itmo/ctlab/virgo/gmwcs/graph/Graph;", "solve", "", "Lru/itmo/ctlab/virgo/gmwcs/graph/Elem;", "Lru/itmo/ctlab/gmwcs/solver/D;", "root", "Lru/itmo/ctlab/virgo/gmwcs/graph/Node;", "parent", "solveComponents", "virgo-solver"})
public final class TreeSolverKt {
    @NotNull
    public static final D solve(@NotNull Graph g, @NotNull Node root, @Nullable Node parent) {
        D bestSub;
        Object v5;
        List<Node> list;
        Intrinsics.checkParameterIsNotNull(g, "g");
        Intrinsics.checkParameterIsNotNull(root, "root");
        if (parent == null) {
            list = g.neighborListOf(root);
        } else {
            List<Node> list2 = g.neighborListOf(root);
            Intrinsics.checkExpressionValueIsNotNull(list2, "g.neighborListOf(root)");
            list = CollectionsKt.minus((Iterable)list2, parent);
        }
        List<Node> children = list;
        Set<Node> withRoot = SetsKt.mutableSetOf(root);
        boolean bl = false;
        Set solutions = new LinkedHashSet();
        double withRootD = root.getWeight();
        D emptySol = new D(root, SetsKt.emptySet(), CollectionsKt.toSet((Iterable)withRoot), 0.0, root.getWeight());
        if (children.isEmpty()) {
            return root.getWeight() < 0.0 ? emptySol : new D(root, withRoot, withRoot, root.getWeight(), root.getWeight());
        }
        for (Edge e : g.edgesOf(root)) {
            Node opp = g.opposite(root, e);
            if (parent != null && Intrinsics.areEqual(opp, parent)) continue;
            boolean bl2 = Intrinsics.areEqual(opp, root) ^ true;
            boolean bl3 = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Node node = opp;
            Intrinsics.checkExpressionValueIsNotNull(node, "opp");
            D sub = TreeSolverKt.solve(g, node, root);
            if (sub.getBestD() > 0.0) {
                solutions.add(sub);
            }
            double d = sub.getWithRootD();
            Edge edge = e;
            Intrinsics.checkExpressionValueIsNotNull(edge, "e");
            if (!(d + edge.getWeight() >= 0.0)) continue;
            withRoot.addAll((Collection<Node>)sub.getWithRoot());
            withRootD += sub.getWithRootD() + e.getWeight();
        }
        solutions.add(emptySol);
        Iterable $this$maxBy$iv = solutions;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v5 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v5 = maxElem$iv;
            } else {
                D it = (D)maxElem$iv;
                boolean bl6 = false;
                double maxValue$iv = it.getBestD();
                do {
                    Object e$iv = iterator$iv.next();
                    D it2 = (D)e$iv;
                    $i$a$-maxBy-TreeSolverKt$solve$bestSub$1 = false;
                    double v$iv = it2.getBestD();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v5 = maxElem$iv;
            }
        }
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        Set<Node> bestSol = (bestSub = (D)v5).getBestD() > withRootD ? bestSub.getBest() : withRoot;
        double d = bestSub.getBestD();
        Set<Node> set = withRoot;
        Set<Node> set2 = bestSol;
        Node node = root;
        boolean bl7 = false;
        double d2 = Math.max(d, withRootD);
        double d3 = withRootD;
        double d4 = d2;
        Set<Node> set3 = set;
        Set<Node> set4 = set2;
        Node node2 = node;
        return new D(node2, set4, set3, d4, d3);
    }

    public static final void mergeEdges(@NotNull Graph g) {
        Intrinsics.checkParameterIsNotNull(g, "g");
        for (Node u : g.vertexSet()) {
            for (Node v : g.neighborListOf(u)) {
                Object v4;
                if (Intrinsics.areEqual(u, v)) {
                    g.removeEdge(g.getEdge(u, v));
                    continue;
                }
                Node node = u;
                Intrinsics.checkExpressionValueIsNotNull(node, "u");
                int n = node.getNum();
                Node node2 = v;
                Intrinsics.checkExpressionValueIsNotNull(node2, "v");
                if (n > node2.getNum()) continue;
                List<Edge> list = g.getAllEdges(u, v);
                Intrinsics.checkExpressionValueIsNotNull(list, "g.getAllEdges(u, v)");
                Iterable $this$maxBy$iv = list;
                boolean $i$f$maxBy = false;
                Iterator iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v4 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v4 = maxElem$iv;
                    } else {
                        Edge it = (Edge)maxElem$iv;
                        boolean bl = false;
                        Edge edge = it;
                        Intrinsics.checkExpressionValueIsNotNull(edge, "it");
                        double maxValue$iv = edge.getWeight();
                        do {
                            Object e$iv = iterator$iv.next();
                            Edge it2 = (Edge)e$iv;
                            $i$a$-maxBy-TreeSolverKt$mergeEdges$e$1 = false;
                            Edge edge2 = it2;
                            Intrinsics.checkExpressionValueIsNotNull(edge2, "it");
                            double v$iv = edge2.getWeight();
                            if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v4 = maxElem$iv;
                    }
                }
                Edge e = v4;
                List<Edge> list2 = g.getAllEdges(u, v);
                Intrinsics.checkExpressionValueIsNotNull(list2, "g.getAllEdges(u, v)");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Edge it = (Edge)element$iv;
                    boolean bl = false;
                    g.removeEdge(it);
                }
                g.addEdge(u, v, e);
            }
        }
    }

    public static final double mapWeight(double w) {
        return w > 0.0 ? 1.0 / w : (w == 0.0 ? 1.0 : 1.0 - 1.0 / w);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Elem> solveComponents(@NotNull Graph g) {
        Object v2;
        Object object;
        Graph it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List<Set<Node>> components;
        Intrinsics.checkParameterIsNotNull(g, "g");
        List<Set<Node>> list = components = g.connectedSets();
        Intrinsics.checkExpressionValueIsNotNull(list, "components");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Set set = (Set)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = g.subgraph((Set<Node>)((Object)it));
            collection.add(object);
        }
        List gs = (List)destination$iv$iv;
        $this$map$iv = gs;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Graph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Graph graph = it;
            Intrinsics.checkExpressionValueIsNotNull(graph, "it");
            object = TreeSolverKt.solve(graph);
            collection.add(object);
        }
        Iterable $this$maxBy$iv = (List)destination$iv$iv;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                Set it2 = (Set)maxElem$iv;
                boolean bl = false;
                Iterable $this$sumByDouble$iv = it2;
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (Object element$iv : $this$sumByDouble$iv) {
                    void it3;
                    Elem elem = (Elem)element$iv;
                    double d = sum$iv;
                    boolean bl2 = false;
                    double d2 = it3.getWeight();
                    sum$iv = d + d2;
                }
                double maxValue$iv = sum$iv;
                do {
                    Object e$iv = iterator$iv.next();
                    Set it4 = (Set)e$iv;
                    $i$a$-maxBy-TreeSolverKt$solveComponents$2 = false;
                    Iterable $this$sumByDouble$iv2 = it4;
                    boolean $i$f$sumByDouble2 = false;
                    double sum$iv2 = 0.0;
                    for (Object element$iv : $this$sumByDouble$iv2) {
                        void it5;
                        Elem elem = (Elem)element$iv;
                        double d = sum$iv2;
                        boolean bl3 = false;
                        double d3 = it5.getWeight();
                        sum$iv2 = d + d3;
                    }
                    double v$iv = sum$iv2;
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        Set set = v2;
        boolean bl = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Elem> solve(@NotNull Graph g) {
        Intrinsics.checkParameterIsNotNull(g, "g");
        Random random = new Random(1337L);
        TreeSolverKt.mergeEdges(g);
        D res = null;
        int n = 0;
        int n2 = 10;
        while (n <= n2) {
            void i;
            void $this$mapTo$iv$iv;
            Set<Node> set = g.vertexSet();
            Intrinsics.checkExpressionValueIsNotNull(set, "g.vertexSet()");
            Node r = (Node)CollectionsKt.toList((Iterable)set).get(random.nextInt(g.vertexSet().size()));
            Set<Edge> set2 = g.edgeSet();
            Intrinsics.checkExpressionValueIsNotNull(set2, "g.edgeSet()");
            Iterable $this$map$iv = set2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Edge edge = (Edge)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull(v2, "it");
                Pair<void, Double> pair = new Pair<void, Double>(it, TreeSolverKt.mapWeight(v2.getWeight()));
                collection.add(pair);
            }
            Map<Edge, Double> weights = MapsKt.toMap((List)destination$iv$iv);
            MSTSolver mst = new MSTSolver(g, weights, r);
            mst.solve();
            Set<Node> set3 = g.vertexSet();
            List<Edge> list = mst.getEdges();
            Intrinsics.checkExpressionValueIsNotNull(list, "mst.edges");
            Graph graph = g.subgraph(set3, CollectionsKt.toSet((Iterable)list));
            Intrinsics.checkExpressionValueIsNotNull(graph, "g.subgraph(g.vertexSet(), mst.edges.toSet())");
            Node node = r;
            Intrinsics.checkExpressionValueIsNotNull(node, "r");
            D sol = TreeSolverKt.solve(graph, node, null);
            if (res == null || sol.getBestD() > res.getBestD()) {
                res = sol;
            }
            ++i;
        }
        D d = res;
        if (d == null) {
            Intrinsics.throwNpe();
        }
        Set<Elem> set = g.subgraph(d.getBest()).elemSet();
        Intrinsics.checkExpressionValueIsNotNull(set, "g.subgraph(res!!.best).elemSet()");
        return set;
    }

    public static final void main(@NotNull String[] args2) {
        Node it;
        Elem element$iv;
        int n;
        Intrinsics.checkParameterIsNotNull(args2, "args");
        Graph g = new Graph();
        Node[] nodes = new Node[]{new Node(1, -5.0), new Node(2, -1.0), new Node(3, -2.0)};
        Edge[] edges = new Edge[]{new Edge(1, 1.0), new Edge(2, -1.0)};
        Elem[] $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        Elem[] elemArray = $this$forEach$iv;
        int n2 = elemArray.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = elemArray[n];
            boolean bl = false;
            g.addVertex(it);
        }
        $this$forEach$iv = edges;
        $i$f$forEach = false;
        elemArray = $this$forEach$iv;
        n2 = elemArray.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = elemArray[n];
            boolean bl = false;
            g.addEdge(nodes[it.getNum() - 1], nodes[it.getNum()], (Edge)((Object)it));
        }
        double d = TreeSolverKt.solve(g, nodes[1], null).getWithRootD();
        boolean bl = false;
        System.out.print(d);
    }
}

