% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{mc_calc_vwc}
\alias{mc_calc_vwc}
\title{Conversion of raw TMS soil moisture values to volumetric water content (VWC)}
\usage{
mc_calc_vwc(
  data,
  moist_sensor = mc_const_SENSOR_TMS_moist,
  temp_sensor = mc_const_SENSOR_TMS_T1,
  output_sensor = "VWC_moisture",
  soiltype = "universal",
  localities = NULL,
  ref_t = mc_const_CALIB_MOIST_REF_T,
  acor_t = mc_const_CALIB_MOIST_ACOR_T,
  wcor_t = mc_const_CALIB_MOIST_WCOR_T,
  frozen2NA = TRUE
)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{moist_sensor}{name of soil moisture sensor to be converted from TMS
moisture values to volumetric water content (default "TMS_moist") see \code{names(mc_data_sensors)}.
Soil moisture sensor must be in moisture_raw physical units see \code{names(mc_data_physical)}.}

\item{temp_sensor}{name of soil temperature sensor (default "TMS_T1")
see \code{names(mc_data_sensors)}. Temperature sensor must be in T_C physical units.}

\item{output_sensor}{name of new virtual sensor with VWC values (default "VWC_moisture")}

\item{soiltype}{Either character corresponding to one of \code{soiltype} from \link{mc_data_vwc_parameters}
(default \code{"universal"}), or a list with parameters \code{a}, \code{b} and \code{c} provided
by the user - i.e.,\code{list(a=Value_1, b=Value_2, c=Value_3)}.}

\item{localities}{list of locality_ids used for calculation; if NULL then all localities are used (default NULL)}

\item{ref_t}{(default 24)}

\item{acor_t}{(default 1.91132689118083) correction parameter for temperature drift
in the air, see \code{\link[=mc_calib_moisture]{mc_calib_moisture()}}}

\item{wcor_t}{(default 0.64108) correction parameter for temperature drift
in the water, see \code{\link[=mc_calib_moisture]{mc_calib_moisture()}}}

\item{frozen2NA}{if TRUE then VWC values are set to NA when the soil temperature is below 0 °C (default TRUE)}
}
\value{
myClim object same as input but with added virtual VWC moisture sensor
}
\description{
This function creates a new virtual sensor on the locality within the myClim data object.
Function converts the raw TMS soil moisture (scaled TDT signal)
to volumetric water content (VWC).
}
\details{
This function is suitable for TOMST TMS loggers measuring soil moisture in raw TMS units.
The raw TMS units represents inverted and numerically rescaled (1-4095) electromagnetic signal from the moisture sensor working
on Time Domain Transmission principle (Wild et al. 2019). For TMS4 logger, the typical raw TMS moisture values range from cca
115 units in dry air to cca 3635 units in distilled water - see \link{mc_calib_moisture}.

Raw TMS moisture values can be converted to the soil volumetric water content with calibration curves. The function provides
several experimentally derived calibration curves which were developped at reference temperature. To account for the difference
between reference and actual temperature, the function use actual soil temperature values measured by TMS_T1 soil temperature
sensor.

The default calibration curve is "universal", which was designed for mineral soils (see Kopecký et al. 2021).
Specific calibration curves were developed for several soil types (see Wild et al. 2019) and the user can choose one of these
or can define its own calibration - see \link{mc_data_vwc_parameters}

Currently available calibration curves are: sand, loamy sand A,
loamy sand B, sandy loam A, sandy loam B, loam, silt loam, peat, water,
universal, sand TMS1, loamy sand TMS1, silt loam TMS1.
For details see \link{mc_data_vwc_parameters}.

It is also possible to define new calibarion function with custom parameters \code{a}, \code{b} and \code{c}. These can be
derived e.g. from TOMST TMS Calibr utility after entering custom ratio of clay, silt, sand.

\strong{Warning:} TOMST TMS Calibr utility was developed for TMS3 series of TMS loggers, which have
different range of raw soil moisture values than TMS4 series.

The function by default replace the moisture records in frozen soils with NA (param \emph{frozen2NA}),
because the TMS soil moisture sensor was not designed to measure in frozen soils and the returned values are thus not comparable
with values from non-frozen soil.
}
\examples{
data1 <- mc_calc_vwc(mc_data_example_agg, soiltype="sand", localities="A2E32")
data2 <- mc_calc_vwc(mc_data_example_agg, localities="A2E32",
                     soiltype=list(a=-3.00e-09, b=0.000161192, c=-0.109956505))
}
\references{
Wild, J., Kopecký, M., Macek, M., Šanda, M., Jankovec, J., Haase, T. (2019) Climate at ecologically relevant scales:
A new temperature and soil moisture logger for long-term microclimate measurement. Agriculture and Forest Meteorology 268, 40-47.
https://doi.org/10.1016/j.agrformet.2018.12.018

Kopecký, M., Macek, M., Wild, J. (2021) Topographic Wetness Index calculation guidelines based on measured soil
moisture and plant species composition. Science of the Total Environment 757, 143785. https://doi.org/10.1016/j.scitotenv.2020.143785
}
\seealso{
\link{mc_data_vwc_parameters}
}
