% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rel_exp.R
\name{REMatrix}
\alias{REMatrix}
\title{Compute a Relative Expression Matrix}
\usage{
REMatrix(ExpressionSet)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}
}
\description{
This function computes the relative expression profiles of
all given phylostrata or divergence-strata within a given PhyloExpressionSet or DivergenceExpressionSet.
}
\details{
For each phylostratum or divergence-stratum the corresponding relative expression profile is being computed as follows:

\deqn{f_js = ( e_js - e_j min ) / ( e_j max - e_j min )}

where \eqn{e_j min} and \eqn{e_j max} denote the minimum/maximum mean expression level of
phylostratum j over the  developmental stages s. This linear transformation corresponds
to a shift by \eqn{e_j min} and a subsequent shrinkage by \eqn{e_j max - e_j min}.
As a result, the relative expression level \eqn{f_js} of developmental stage s with minimum \eqn{e_js} is 0,
the relative expression level \eqn{f_js} of the developmental stage s with maximum \eqn{e_js} is 1,
and the relative expression levels \eqn{f_js} of all other stages s range between 0 and 1, accordingly.
}
\examples{
# read standard phylotranscriptomics data
data(PhyloExpressionSetExample)
data(DivergenceExpressionSetExample)

# example PhyloExpressionSet
REMatrix(PhyloExpressionSetExample)

# example DivergenceExpressionSet
REMatrix(DivergenceExpressionSetExample)
}
\author{
Hajk-Georg Drost
}
\references{
Domazet-Loso T and Tautz D. (2010). \emph{A phylogenetically based transcriptome age index mirrors ontogenetic divergence patterns}. Nature (468): 815-818.

Quint M et al. (2012). \emph{A transcriptomic hourglass in plant embryogenesis}. Nature (490): 98-101.
}
\seealso{
\code{\link{RE}}, \code{\link{PlotRE}}, \code{\link{PlotBarRE}}
}

