## ---- echo = FALSE, message = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(myTAI)
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # load myTAI
#  library(myTAI)
#  
#  # load example data sets (stored in myTAI)
#  data(PhyloExpressionSetExample)
#  data(DivergenceExpressionSetExample)
#  
#  # show an example phylostratigraphic map of Arabidopsis thaliana
#  head(PhyloExpressionSetExample[ , c("Phylostratum","GeneID")])
#  

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show an example structure of a Divergence Map
#  head(DivergenceExpressionSetExample[ , c("Divergence.stratum","GeneID")])
#  

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(myTAI)
#  
#  # load the example data set
#  data(PhyloExpressionSetExample)
#  
#  # construct an example Phylostratigraphic Map
#  Example.PhylostratigraphicMap <- PhyloExpressionSetExample[ , 1:2]
#  # construct an example ExpressionMatrix
#  Example.ExpressionMatrix <- PhyloExpressionSetExample[ , 2:9]
#  
#  # join a PhylostratigraphicMap with an ExpressionMatrix using MatchMap()
#  Example.PhyloExpressionSet <- MatchMap(Example.PhylostratigraphicMap, Example.ExpressionMatrix)
#  
#  # look at a standard PhyloExpressionSet
#  head(Example.PhyloExpressionSet, 3)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # head of an example standard DivergenceExpressionSet
#  head(DivergenceExpressionSetExample, 3)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # used by all myTAI functions to check the validity of the PhyloExpressionSet standard
#  is.ExpressionSet(PhyloExpressionSetExample)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # used a non standard PhyloExpressionSet
#  head(PhyloExpressionSetExample[ , 2:5], 2)

## ---- error = TRUE,eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  is.ExpressionSet(PhyloExpressionSetExample[ , 2:5])

## ---- fig.width= 7, fig.height= 5,eval=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data(PhyloExpressionSetExample)
# Plot the Transcriptome Age Index of a given PhyloExpressionSet 
# Test Statistic : Flat Line Test (default)
PlotSignature( ExpressionSet = PhyloExpressionSetExample,
               measure       = "TAI", 
               TestStatistic = "FlatLineTest",
               xlab          = "Ontogeny", 
               ylab          = "TAI" )

## ---- fig.width= 9, fig.height= 5,eval=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data(PhyloExpressionSetExample)
# category-centered visualization of PS 
# specific expression level distributions (log-scale)
PlotCategoryExpr(ExpressionSet = PhyloExpressionSetExample,
                     legendName    = "PS",
                     test.stat     = TRUE,
                     type          = "category-centered",
                     distr.type    = "boxplot",
                     log.expr      = TRUE)

## ---- fig.width= 9, fig.height= 5,eval=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data(PhyloExpressionSetExample)
# plot evolutionary old PS (PS1-3) vs
# evolutionary young PS (PS4-12)
PlotMeans(PhyloExpressionSetExample,
          Groups = list(c(1:3), c(4:12)), 
          legendName = "PS",
          adjust.range = TRUE)

## ---- fig.width= 9, fig.height= 5,eval=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data(PhyloExpressionSetExample)
# plot evolutionary old PS (PS1-3) vs
# evolutionary young PS (PS4-12)
PlotRE(PhyloExpressionSetExample,
          Groups = list(c(1:3), c(4:12)), 
          legendName = "PS",
          adjust.range = TRUE)

## ----eval=TRUE,echo=FALSE,fig.width= 7, fig.height= 15----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# select PS4-12 genes
PhyloExpressionSetExample.PS4_12 <-
        dplyr::filter(PhyloExpressionSetExample, Phylostratum %in% c(4:12))
# categorize A. thaliana embryogenesis into three 
# developmental modules (early, mid, and late)
Ath.Embryogenesis.DiffGenes <-
        DiffGenes(
        ExpressionSet = PhyloExpressionSetExample.PS4_12,
        nrep          = c(2, 3, 2),
        stage.names   = c("Early", "Mid", "Late")
        )

# cluster young genes (PS4-12) according to their fold-change pattern: High-Low-Low        
Ath.Embryo.High_Low_Low <-
        PhyloExpressionSetExample.PS4_12[which((Ath.Embryogenesis.DiffGenes[, "Early->Mid"] > 3) &
        (dplyr::between(Ath.Embryogenesis.DiffGenes[, "Mid->Late"], 1, 2))),]

# cluster young genes (PS4-12) according to their fold-change pattern: High-Low-High
Ath.Embryo.High_Low_High <-
        PhyloExpressionSetExample.PS4_12[which((Ath.Embryogenesis.DiffGenes[, "Early->Mid"] > 3) &
        (Ath.Embryogenesis.DiffGenes[, "Mid->Late"] < 0.2)),]

# cluster young genes (PS4-12) according to their fold-change pattern: Low-Low-High        
Ath.Embryo.Low_Low_High <-
        PhyloExpressionSetExample.PS4_12[which((dplyr::between(Ath.Embryogenesis.DiffGenes[, "Early->Mid"], 1, 2)) &
        (Ath.Embryogenesis.DiffGenes[, "Mid->Late"] < 0.2)),]
        
        
        par(mfrow = c(3, 1))
        matplot(
        t(Ath.Embryo.High_Low_Low[, 3:9]),
        type = "l",
        lty = 1,
        lwd = 2,
        col = "lightblue",
        xlab = "Ontogeny",
        ylab = "Expression Level",
        xaxt = "n",
        cex.lab = 1.5,
        cex.axis = 1.5,
        main = "High-Low-Low"
        )
        lines(
        colMeans(Ath.Embryo.High_Low_Low[, 3:9]),
        lwd = 6 ,
        col = "red",
        cex.lab = 1.5,
        cex.axis = 1.5,
        cex = 1.5
        )
        axis(1, 1:7, names(PhyloExpressionSetExample)[3:9])
        text(
        4,
        max(Ath.Embryo.High_Low_Low[, 3:9]) - 6000,
        labels = paste0(nrow(Ath.Embryo.High_Low_Low), " Genes"),
        cex = 2
        )
        
        matplot(
        t(Ath.Embryo.High_Low_High[, 3:9]),
        type = "l",
        lty = 1,
        lwd = 2,
        col = "lightblue",
        xlab = "Ontogeny",
        ylab = "Expression Level",
        xaxt = "n",
        cex.lab = 1.5,
        cex.axis = 1.5,
        main = "High-Low-High"
        )
        lines(
        colMeans(Ath.Embryo.High_Low_High[, 3:9]),
        lwd = 6 ,
        col = "red",
        cex.lab = 1.5,
        cex.axis = 1.5,
        cex = 1.5
        )
        axis(1, 1:7, names(PhyloExpressionSetExample)[3:9])
        text(
        4,
        max(Ath.Embryo.High_Low_High[, 3:9]) - 6000,
        labels = paste0(nrow(Ath.Embryo.High_Low_High), " Genes"),
        cex = 2
        )
        
        matplot(
        t(Ath.Embryo.Low_Low_High[, 3:9]),
        type = "l",
        lty = 1,
        lwd = 2,
        col = "lightblue",
        xlab = "Ontogeny",
        ylab = "Expression Level",
        xaxt = "n",
        cex.lab = 1.5,
        cex.axis = 1.5,
        main = "Low-Low-High"
        )
        lines(
        colMeans(Ath.Embryo.Low_Low_High[, 3:9]),
        lwd = 6 ,
        col = "red",
        cex.lab = 1.5,
        cex.axis = 1.5,
        cex = 1.5
        )
        axis(1, 1:7, names(PhyloExpressionSetExample)[3:9])
        text(
        4,
        max(Ath.Embryo.Low_Low_High[, 3:9]) - 6000,
        labels = paste0(nrow(Ath.Embryo.Low_Low_High), " Genes"),
        cex = 2
        )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(PhyloExpressionSetExample)
#  # Plot the Transcriptome Age Index of a given PhyloExpressionSet
#  # Test Statistic : Flat Line Test (default)
#  PlotSignature( ExpressionSet = PhyloExpressionSetExample,
#                 measure       = "TAI",
#                 TestStatistic = "FlatLineTest",
#                 xlab          = "Ontogeny",
#                 ylab          = "TAI" )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot the Transcriptome Age Index of a given PhyloExpressionSet
#  # Test Statistic : Reductive Hourglass Test
#  PlotSignature( ExpressionSet = PhyloExpressionSetExample,
#                 measure       = "TAI",
#                 TestStatistic = "ReductiveHourglassTest",
#                 modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#                 xlab          = "Ontogeny",
#                 ylab          = "TAI" )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualize the phylotypic period used for the Reductive Hourglass Test
#  PlotSignature( ExpressionSet = PhyloExpressionSetExample,
#                 measure       = "TAI",
#                 TestStatistic = "ReductiveHourglassTest",
#                 modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#                 shaded.area   = TRUE,
#                 xlab          = "Ontogeny",
#                 ylab          = "TAI" )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot the Transcriptome Age Index of a given PhyloExpressionSet
#  # Test Statistic : Reductive Early Conservation Test
#  PlotSignature( ExpressionSet = PhyloExpressionSetExample,
#                 measure       = "TAI",
#                 TestStatistic = "EarlyConservationTest",
#                 modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#                 xlab          = "Ontogeny",
#                 ylab          = "TAI" )

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Compute the Transcriptome Age Index values of a given PhyloExpressionSet
#  TAI(PhyloExpressionSetExample)

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(DivergenceExpressionSetExample)
#  # Plot the Transcriptome Divergence Index of a given DivergenceExpressionSet
#  # Test Statistic : Flat Line Test (default)
#  PlotSignature( ExpressionSet = DivergenceExpressionSetExample,
#                 measure       = "TDI",
#                 TestStatistic = "FlatLineTest",
#                 xlab          = "Ontogeny",
#                 ylab          = "TDI" )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(DivergenceExpressionSetExample)
#  # Plot the Transcriptome Divergence Index of a given DivergenceExpressionSet
#  # Test Statistic : Reductive Hourglass Test
#  PlotSignature( ExpressionSet = DivergenceExpressionSetExample,
#                 measure       = "TDI",
#                 TestStatistic = "ReductiveHourglassTest",
#                 modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#                 xlab          = "Ontogeny",
#                 ylab          = "TDI" )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(DivergenceExpressionSetExample)
#  # Plot the Transcriptome Divergence Index of a given DivergenceExpressionSet
#  # Test Statistic : Reductive Early Conservation Test
#  PlotSignature( ExpressionSet = DivergenceExpressionSetExample,
#                 measure       = "TDI",
#                 TestStatistic = "EarlyConservationTest",
#                 modules       = list(early = 1:2, mid = 3:5, late = 6:7),
#                 xlab          = "Ontogeny",
#                 ylab          = "TDI" )

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Compute the Transcriptome Divergence Index values of a given DivergenceExpressionSet
#  TDI(DivergenceExpressionSetExample)

## ---- fig.width= 7, fig.height= 5, eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(PhyloExpressionSetExample)
#  # visualize phylostrata contribution to the global TAI pattern
#   PlotContribution( ExpressionSet = PhyloExpressionSetExample,
#                     legendName    = "PS",
#                     xlab           = "Ontogeny",
#                     ylab           = "Transcriptome Age Index",
#                     y.ticks        = 10)

## ----eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  pTAI(PhyloExpressionSetExample)

## ---- fig.width= 7, fig.height= 5, eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(DivergenceExpressionSetExample)
#  # visualize divergence stratum contribution to global TDI
#   PlotContribution( ExpressionSet = DivergenceExpressionSetExample,
#                     legendName    = "DS")

## ----eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  pTDI(DivergenceExpressionSetExample)

## ----eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show that the cumulative TAI value of PS 12 is
#  # equavalent to the global TAI() values
#  pTAI(PhyloExpressionSetExample)[12 , ]
#  
#  # >  Zygote Quadrant Globular    Heart  Torpedo     Bent   Mature
#  # > 3.229942 3.225614 3.107135 3.116693 3.073993 3.176511 3.390334
#  
#  TAI(PhyloExpressionSetExample)
#  
#  # >  Zygote Quadrant Globular    Heart  Torpedo     Bent   Mature
#  # > 3.229942 3.225614 3.107135 3.116693 3.073993 3.176511 3.390334

## ----eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show that the colSum() of partial TAI values
#  # over all Phylostrata equals the global TAI() values
#  apply(pStrata(PhyloExpressionSetExample) , 2 , sum)
#  
#  # >  Zygote Quadrant Globular    Heart  Torpedo     Bent   Mature
#  # > 3.229942 3.225614 3.107135 3.116693 3.073993 3.176511 3.390334

## ----eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show that apply(pStrata(PhyloExpressionSetExample) , 2 , cumsum)
#  # is equivalent to pTAI()
#  apply(pStrata(PhyloExpressionSetExample) , 2 , cumsum)

## ----eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  pTAI(PhyloExpressionSetExample)

## ----eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # compute partial TAI values for each Phylostratum
#  pStrata(PhyloExpressionSetExample)

## ----eval = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # compute partial TAI values for each gene
#  dplyr::glimpse(pMatrix(PhyloExpressionSetExample))

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  PlotMeans( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(1:12),
#             legendName    = "PS")

## ---- fig.height= 5, fig.width=7,eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  # in two separate plots (groups)
#  PlotMeans( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(group_1 = 1:3, group_2 = 4:12),
#             legendName    = "PS")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Using the age.apply() function to compute the mean expression levels
#  # of all Phylostrata
#  age.apply( ExpressionSet = PhyloExpressionSetExample,
#             FUN           = colMeans )

## ---- fig.height= 5, fig.width=7,eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  # and draw an shaded area for the mid-module.
#  PlotMeans( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(1:12),
#             modules       = list(1:2,3:5,6:7),
#             legendName    = "PS")

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(DivergenceExpressionSetExample)
#  # Visualizing the mean gene expression of each Divergence Stratum class
#  PlotMeans( ExpressionSet = DivergenceExpressionSetExample,
#             Groups        = list(1:10),
#             legendName    = "DS",
#             xlab          = "Ontogeny")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Using the age.apply() function to compute the mean expression levels
#  # of all Divergence Strata
#  age.apply( ExpressionSet = DivergenceExpressionSetExample,
#             FUN           = colMeans )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  PlotRE( ExpressionSet = PhyloExpressionSetExample,
#          Groups        = list(1:12),
#          legendName    = "PS",
#          xlab          = "Ontogeny")

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  data(DivergenceExpressionSetExample)
#  # Visualizing the mean gene expression of each Divergence Stratum class
#  PlotRE( ExpressionSet = DivergenceExpressionSetExample,
#          Groups        = list(1:10),
#          legendName    = "DS",
#          xlab          = "Ontogeny")

## ----fig.height=5, fig.width=7,eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  PlotRE( ExpressionSet = PhyloExpressionSetExample,
#          Groups        = list(group_1 = 1:3, group_2 = 4:12),
#          legendName    = "PS",
#          xlab          = "Ontogeny")

## ----fig.height=5, fig.width=7,eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean gene expression of each Phylostratum class
#  PlotRE( ExpressionSet = PhyloExpressionSetExample,
#          Groups        = list(1:12),
#          modules = list(1:2,3:5,6:7),
#          legendName    = "PS",
#          xlab          = "Ontogeny")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Getting the relative expression levels for all Phylostrata
#  REMatrix(PhyloExpressionSetExample)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Getting the relative expression levels for all Divergence-Strata
#  REMatrix(DivergenceExpressionSetExample)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Getting the relative expression levels for all Phylostrata
#  age.apply( ExpressionSet = PhyloExpressionSetExample,
#             FUN           = RE )

## ----fig.height=5, fig.width=7,eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean relative expression of two Phylostratum groups
#  PlotBarRE( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(group_1 = 1:3, group_2 = 4:12),
#             xlab          = "Ontogeny",
#             ylab          = "Mean Relative Expression",
#             cex           = 1.5)

## ---- fig.height=5,fig.width=7,eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean relative expression of two Phylostratum groups
#  PlotBarRE( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(group_1 = 1:3, group_2 = 4:12),
#             ratio         = TRUE,
#             xlab          = "Ontogeny",
#             ylab          = "Mean Relative Expression",
#             cex           = 1.5 )

## ---- fig.width=7,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Visualizing the mean relative expression of three Phylostratum groups
#  PlotBarRE( ExpressionSet = PhyloExpressionSetExample,
#             Groups        = list(group_1 = 1:3, group_2 = 4:6, group_3 = 7:12),
#             wLength       = 0.05,
#             xlab          = "Ontogeny",
#             ylab          = "Mean Relative Expression",
#             cex           = 1.5 )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Display the phylostratum distribution (gene frequency distribution)
#  # of a PhyloExpressionSet as absolute frequency distribution
#  PlotDistribution( PhyloExpressionSet = PhyloExpressionSetExample,
#                    xlab               = "Phylostratum" )

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # Plot phylostrata as relative frequency distribution
#  PlotDistribution( PhyloExpressionSet = PhyloExpressionSetExample,
#                    as.ratio           = TRUE,
#                    xlab               = "Phylostratum")

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  
#  # save the TAI profile to a local machine with png()
#  png("ExampleTAIProfile.png", width = 800, height = 600)
#  
#  PlotPattern( ExpressionSet = PhyloExpressionSetExample,
#               type          = "l",
#               lwd           = 6,
#               xlab          = "Ontogeny",
#               ylab          = "TAI",
#               cex           = 1,
#               cex.lab       = 1,
#               cex.axis      = 1.2 )
#  
#  dev.off()

## ---- fig.width= 7, fig.height= 5,eval=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # store ggplot2 graphic in variable p
#  p <- PlotSignature(ExpressionSet = PhyloExpressionSetExample,
#                     ylab          = "Transcriptome Age Index")
#  
#  # save ggplot2 based TAI profile to a local machine with save_plot()
#  cowplot::save_plot("ExampleTAIProfile.pdf",
#                     p,
#                     base_height = 8,
#                     base_width = 12 )

