% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotGeneSet.R
\name{PlotGeneSet}
\alias{PlotGeneSet}
\title{Plot the Expression Profiles of a Gene Set}
\usage{
PlotGeneSet(ExpressionSet, gene.set, get.subset = FALSE,
  use.only.map = FALSE, colors = NULL, plot.legend = TRUE, y.ticks = 6,
  digits.ylab = 4, ...)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{gene.set}{a character vector storing the gene ids for which gene expression profiles shall be visualized.}

\item{get.subset}{a logical value indicating whether or not an \code{ExpressionSet} subset of the selected \code{gene.set} should be retuned.}

\item{use.only.map}{a logical value indicating whether instead of a standard \code{ExpressionSet} only a \code{Phylostratigraphic Map} or \code{Divergene Map} is passed to the function.}

\item{colors}{colors for gene expression profiles. Default: \code{colors = NULL}, hence default colours are used.}

\item{plot.legend}{a logical value indicating whether gene ids should be printed as legend next to the plot.}

\item{y.ticks}{a numeric value specifying the number of ticks to be drawn on the y-axis.}

\item{digits.ylab}{a numeric value specifying the number of digits shown for the expression levels on the y-axis.}

\item{...}{additional parameters passed to \code{\link{matplot}}.}
}
\description{
This function simply visualizes the gene expression profiles of
a defined subset of genes stored in the input \code{ExpressionSet}.
}
\details{
This function simply visualizes or subsets the gene expression levels of a set of genes
that are stored in the input \code{ExpressionSet}.
}
\examples{
data(PhyloExpressionSetExample)

# the best parameter setting to visualize this plot:
# png("test_png.png",700,400)
PlotGeneSet(ExpressionSet = PhyloExpressionSetExample, 
            gene.set      = PhyloExpressionSetExample[1:5, 2], 
            type          = "l", 
            lty           = 1, 
            lwd           = 4,
            xlab          = "Ontogeny",
            ylab          = "Expression Level")

# dev.off()

# In case you would like to work with the expression levels
# of selected genes you can specify the 'get.subset' argument:

PlotGeneSet(ExpressionSet = PhyloExpressionSetExample, 
            gene.set      = PhyloExpressionSetExample[1:5, 2], 
            get.subset    = TRUE)


# get a gene subset using only a phylostratihraphic map
ExamplePSMap <- PhyloExpressionSetExample[ , 1:2]

PlotGeneSet(ExpressionSet = ExamplePSMap, 
            gene.set      = PhyloExpressionSetExample[1:5, 2], 
            get.subset    = TRUE,
            use.only.map  = TRUE)
            
}
\seealso{
\code{\link{SelectGeneSet}}, \code{\link{PlotEnrichment}}, \code{\link{DiffGenes}}
}
\author{
Hajk-Georg Drost
}
