% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCop.R
\name{rCop}
\alias{rCop}
\title{Random number generator for Archimedean copula class objects}
\usage{
rCop(n, copula)
}
\arguments{
\item{n}{number of realisations.}

\item{copula}{an Archimedean copula (archm) class object.}
}
\value{
A numeric matrix containing the samples.
}
\description{
Random number generator for archm class objects.
}
\details{
For bivariate archm copula objects, the function uses the conditional approach.
As for dimensions higher than 2, the Marshall-Olkin (1988) approach is chosen instead.
}
\examples{
## Create the trivariate archm copula object
cop <- Clayton(5, 3)

## Generate the samples
res <- rCop(10000, cop)

## Plot the values
pairs(res, pch = 16, cex = 0.7)

}
\seealso{
\link{pCop}, \link{Clayton}, \link{AMH}, \link{Frank}, \link{Gumbel}
}
\author{
Simon-Pierre Gadoury
}
