% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nltts_plot.R
\name{nltts_plot}
\alias{nltts_plot}
\title{Get the average nLTT from a collection of phylogenies}
\usage{
nltts_plot(phylogenies, dt = 0.001, plot_nltts = FALSE,
  xlab = "Normalized Time", ylab = "Normalized Lineages", replot = FALSE,
  ...)
}
\arguments{
\item{phylogenies}{the phylogenies, where the phylogenies are of type 'phylo'}

\item{dt}{The timestep resolution,
where 1/dt is the number of points evaluated}

\item{plot_nltts}{Also plot each nLLT line}

\item{xlab}{Label on the x axis}

\item{ylab}{Label on the y axis}

\item{replot}{If false, start a clean plot. If true,
plot the new data over the current}

\item{...}{Plotting options}
}
\value{
Nothing
}
\description{
Get the average nLTT from a collection of phylogenies
}
\examples{
  nltts_plot(c(ape::rcoal(10), ape::rcoal(10)))
  nltts_plot(c(ape::rcoal(10), ape::rcoal(20)), dt = 0.1)

}
\author{
Richel Bilderbeek
}
