% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{ForceChannels}
\alias{ForceChannels}
\title{Fix an image that didn't recognise channels while reading}
\usage{
ForceChannels(img.arr, n.ch)
}
\arguments{
\item{img.arr}{An array, the read image.}

\item{n.ch}{The number of channels that you want the read image to have.}
}
\value{
An array, channel indices in the third slot, slice indices in the
fourth.
}
\description{
Sometimes, when you open an image in ImageJ, it displays the channels as you
would like, but when you read it into R, it has just mashed all the channels
(which you would like to be separated somehow) into a stack. In my
expreience, it always does so in a way that, say you have a stack of 3
channels and 5 z positions, then the red images would occupy \code{[, , 1]}, \code{[, , 6]} and \code{[, , 11]}. This function fixes this kind of confusion. So, in that
example it would have a 3d array as input and a 4d as output with dimensions
(assuming our images are 256x256 pixels) \code{256, 256, 3, 5}.
}
\examples{
library(magrittr)
x <- lapply(1:300, function(x) matrix(runif(4), nrow = 2)) \%>\%
  Reduce(function(x, y) abind::abind(x, y, along = 3), .)
str(x)
ForceChannels(x, 6) \%>\% str

}
