% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number.R
\name{number_timeseries}
\alias{number_timeseries}
\title{Create a number time-series.}
\usage{
number_timeseries(img, def, frames_per_set, overlap = FALSE,
  thresh = NULL, detrend = FALSE, quick = FALSE, filt = NULL,
  s = 1, offset = 0, readout_noise = 0, gamma = 1,
  parallel = FALSE)
}
\arguments{
\item{img}{A 4-dimensional array of images indexed by \code{img[y, x, channel, frame]} (an object of class \link[ijtiff:ijtiff_img]{ijtiff::ijtiff_img}). The image to perform the
calculation on. To perform this on a file that has not yet been read in,
set this argument to the path to that file (a string).}

\item{def}{A character. Which definition of number do you want to use, \code{"n"}
or \code{"N"}?}

\item{frames_per_set}{The number of frames with which to calculate the
successive numbers.}

\item{overlap}{A boolean. If \code{TRUE}, the windows used to calculate brightness
are overlapped, if \code{FALSE}, they are not. For example, for a 20-frame image
series with 5 frames per set, if the windows are not overlapped, then the
frame sets used are 1-5, 6-10, 11-15 and 16-20; whereas if they are
overlapped, the frame sets are 1-5, 2-6, 3-7, 4-8 and so on up to 16-20.}

\item{thresh}{The threshold or thresholding method (see
\code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}}) to use on the image prior to
detrending and number calculations. If there are many channels, this may be
specified as a vector or list, one element for each channel.}

\item{detrend}{Detrend your data with \code{\link[detrendr:img_detrend_rh]{detrendr::img_detrend_rh()}}. This is
the best known detrending method for brightness analysis. For more
fine-grained control over your detrending, use the \code{detrendr} package. If
there are many channels, this may be specified as a vector, one element for
each channel.}

\item{quick}{\code{FALSE} repeats the detrending procedure (which has some inherent
randomness) a few times to hone in on the best detrend. \code{TRUE} is quicker,
performing the routine only once. \code{FALSE} is better.}

\item{filt}{Do you want to smooth (\code{filt = 'mean'}) or median (\code{filt = 'median'}) filter the number image using \code{\link[=smooth_filter]{smooth_filter()}} or
\code{\link[=median_filter]{median_filter()}} respectively? If selected, these are invoked here with a
filter radius of 1 (with corners included, so each median is the median of
9 elements) and with the option \code{na_count = TRUE}. If you want to
smooth/median filter the number image in a different way, first calculate
the numbers without filtering (\code{filt = NULL}) using this function and then
perform your desired filtering routine on the result. If there are many
channels, this may be specified as a vector, one element for each channel.}

\item{s}{A positive number. The \eqn{S}-factor of microscope acquisition.}

\item{offset}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{readout_noise}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{gamma}{Factor for correction of number \eqn{n} due to the illumination
profile. The default (\code{gamma = 1}) has no effect. Changing gamma will have
the effect of dividing the result by \code{gamma}, so the result with \code{gamma = 0.5} is two times the result with \code{gamma = 1}. For a Gaussian illumination
profile, use \code{gamma = 0.3536}; for a Gaussian-Lorentzian illumination
profile, use \code{gamma = 0.0760}.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\value{
An object of class \link{number_ts_img}.
}
\description{
Given a stack of images \code{img}, use the first \code{frames_per_set} of them to
create one number image, the next \code{frames_per_set} of them to create the next
number image and so on to get a time-series of number images.
}
\details{
This may discard some images, for example if 175 frames are in the input and
\code{frames_per_set = 50}, then the last 25 are discarded. If detrending is
selected, it is performed on the whole image stack before the sectioning is
done for calculation of numbers.
}
\examples{
img <- ijtiff::read_tif(system.file('extdata', '50.tif', package = "nandb"))
nts <- number_timeseries(img, "n", frames_per_set = 20, thresh = "Huang")
}
\seealso{
\code{\link[=number]{number()}}.
}
