% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-miss-x.R
\name{gg_miss_span}
\alias{gg_miss_span}
\title{Plot the number of missings in a given repeating span}
\usage{
gg_miss_span(data, var, span_every)
}
\arguments{
\item{data}{data.frame}

\item{var}{a bare unquoted variable name from \code{data}.}

\item{span_every}{integer describing the length of the span to be explored}
}
\value{
ggplot2 object
}
\description{
\code{gg_miss_span} is a replacement function to
\code{imputeTS::plotNA.distributionBar(tsNH4, breaksize = 100)}, which shows the
number of missings in a given span, or breaksize. A default minimal theme
is used, which can be customised as normal for ggplot.
}
\examples{

miss_var_span(pedestrian, hourly_counts, span_every = 3000)
library(ggplot2)
gg_miss_span(pedestrian, hourly_counts, span_every = 3000)
# works with the rest of ggplot
gg_miss_span(pedestrian, hourly_counts, span_every = 3000) + labs(x = "custom")
gg_miss_span(pedestrian, hourly_counts, span_every = 3000) + theme_dark()
}
