% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace-to-na.R
\name{replace_to_na}
\alias{replace_to_na}
\title{Replace values with missings}
\usage{
replace_to_na(data, to_na = list(), ...)
}
\arguments{
\item{data}{A data.frame}

\item{to_na}{A named list given the NA to replace values}

\item{...}{additional arguments for methods.}
}
\value{
values replaced by NA
}
\description{
Specify variables and their values that you want to convert to missing values.
This is a complement to \code{tidyr::replace_na}.
}
\examples{

dat_ms <- tibble::tribble(~x,  ~y,    ~z,
                         1,   "A",   -100,
                         3,   "N/A", -99,
                         NA,  NA,    -98,
                         -99, "E",   -101,
                         -98, "F",   -1)

replace_to_na(dat_ms,
             to_na = list(x = -99))

replace_to_na(dat_ms,
             to_na = list(x = -98))

replace_to_na(dat_ms,
             to_na = list(x = c(-99, -98)))

replace_to_na(dat_ms,
             to_na = list(x = c(-99, -98),
                          y = c("N/A")))

replace_to_na(dat_ms,
             to_na = list(x = c(-99, -98),
                          y = c("N/A"),
                          z = c(-101)))
}
