% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace-with-na.R
\name{replace_with_na}
\alias{replace_with_na}
\title{Replace values with missings}
\usage{
replace_with_na(data, replace = list(), ...)
}
\arguments{
\item{data}{A data.frame}

\item{replace}{A named list given the NA to replace values for each column}

\item{...}{additional arguments for methods. Currently unused}
}
\value{
Dataframe with values replaced by NA.
}
\description{
Specify variables and their values that you want to convert to missing values.
This is a complement to \code{tidyr::replace_na}.
}
\examples{

dat_ms <- tibble::tribble(~x,  ~y,    ~z,
                         1,   "A",   -100,
                         3,   "N/A", -99,
                         NA,  NA,    -98,
                         -99, "E",   -101,
                         -98, "F",   -1)

replace_with_na(dat_ms,
               replace = list(x = -99))

replace_with_na(dat_ms,
             replace = list(x = -98))

replace_with_na(dat_ms,
             replace = list(x = c(-99, -98)))

replace_with_na(dat_ms,
             replace = list(x = c(-99, -98),
                          y = c("N/A")))

replace_with_na(dat_ms,
             replace = list(x = c(-99, -98),
                          y = c("N/A"),
                          z = c(-101)))
}
\seealso{
\url{replace_with_na} \url{replace_with_na_all} \url{replace_with_na_at} \url{replace_with_na_if}
}
