% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-cols.R
\name{add_label_shadow}
\alias{add_label_shadow}
\title{Add a column describing whether there is a shadow}
\usage{
add_label_shadow(data, ..., missing = "Missing",
  complete = "Not Missing")
}
\arguments{
\item{data}{data.frame}

\item{...}{extra variable to label}

\item{missing}{character a label for when values are missing - defaults to "Missing"}

\item{complete}{character character a label for when values are complete - defaults to "Not Missing"}
}
\value{
data.frame with a column, "any_missing", which describes whether or
not there are any rows that have a shadow value.
}
\description{
Instead of focussing on labelling whether there are missings, we instead
focus on whether there have been any shadows created. This can be useful
when data has been imputed and you need to determine which rows contained
missing values when the shadow was bound to the dataset.
}
\examples{

airquality \%>\%
  add_shadow(Ozone, Solar.R) \%>\%
  add_label_shadow()

}
\seealso{
\code{\link[=bind_shadow]{bind_shadow()}} \code{\link[=add_any_miss]{add_any_miss()}} \code{\link[=add_label_missings]{add_label_missings()}} \code{\link[=add_label_shadow]{add_label_shadow()}} \code{\link[=add_miss_cluster]{add_miss_cluster()}} \code{\link[=add_n_miss]{add_n_miss()}} \code{\link[=add_prop_miss]{add_prop_miss()}} \code{\link[=add_shadow_shift]{add_shadow_shift()}} \code{\link[=cast_shadow]{cast_shadow()}}
}
