% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-miss-span.R
\name{gg_miss_span}
\alias{gg_miss_span}
\title{Plot the number of missings in a given repeating span}
\usage{
gg_miss_span(data, var, span_every, facet)
}
\arguments{
\item{data}{data.frame}

\item{var}{a bare unquoted variable name from \code{data}.}

\item{span_every}{integer describing the length of the span to be explored}

\item{facet}{(optional) a single bare variable name, if you want to create a faceted plot.}
}
\value{
ggplot2 showing the number of missings in a span (window, or breaksize)
}
\description{
\code{gg_miss_span} is a replacement function to
\code{imputeTS::plotNA.distributionBar(tsNH4, breaksize = 100)}, which shows the
number of missings in a given span, or breaksize. A default minimal theme
is used, which can be customised as normal for ggplot.
}
\examples{

miss_var_span(pedestrian, hourly_counts, span_every = 3000)
\dontrun{
library(ggplot2)
gg_miss_span(pedestrian, hourly_counts, span_every = 3000)
gg_miss_span(pedestrian, hourly_counts, span_every = 3000, facet = sensor_name)
# works with the rest of ggplot
gg_miss_span(pedestrian, hourly_counts, span_every = 3000) + labs(x = "custom")
gg_miss_span(pedestrian, hourly_counts, span_every = 3000) + theme_dark()
}
}
\seealso{
\code{\link[=geom_miss_point]{geom_miss_point()}} \code{\link[=gg_miss_case]{gg_miss_case()}} \link{gg_miss_case_cumsum} \code{\link[=gg_miss_fct]{gg_miss_fct()}} \code{\link[=gg_miss_var]{gg_miss_var()}} \code{\link[=gg_miss_var_cumsum]{gg_miss_var_cumsum()}} \code{\link[=gg_miss_which]{gg_miss_which()}}
}
