% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{recv_aio}
\alias{recv_aio}
\title{Receive Async}
\usage{
recv_aio(
  socket,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw"),
  timeout,
  keep.raw = TRUE
)
}
\arguments{
\item{socket}{a Socket or Context.}

\item{mode}{[default 'serial'] mode of vector to be received - one of 'serial',
'character', 'complex', 'double', 'integer', 'logical', 'numeric', or 'raw'.
The default 'serial' means a serialised R object, for the other modes,
the raw vector received will be converted into the respective mode.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}

\item{keep.raw}{[default TRUE] logical flag whether to keep the received raw
vector (useful for verification e.g. via hashing). If FALSE, will return
the converted data only.}
}
\value{
A recv Aio (object of class 'recvAio').
}
\description{
Receive data asynchronously over a Socket or Context.
}
\details{
Async receive is always non-blocking and returns immediately.

    To wait for the AIO to complete and retrieve the received message,
    use \code{\link{call_aio}} on the returned 'recvAio' object.

    Alternatively, to stop the async operation, use \code{\link{stop_aio}}.
}
\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

send_aio(s1, data.frame(a = 1, b = 2), timeout = 100)
res <- recv_aio(s2, timeout = 100, keep.raw = FALSE)
res
call_aio(res)
res

send_aio(s1, c(1.1, 2.2, 3.3), mode = "raw", timeout = 100)
res <- recv_aio(s2, mode = "double", timeout = 100)
call_aio(res)
res

send_aio(s1, "example message", mode = "raw", timeout = 100)
res <- recv_aio(s2, mode = "character", timeout = 100)
call_aio(res)
res$raw
res$data

close(s1)
close(s2)

}
