% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{send_aio}
\alias{send_aio}
\title{Send Async}
\usage{
send_aio(socket, data, mode = c("serial", "raw"), timeout)
}
\arguments{
\item{socket}{a Socket or Context.}

\item{data}{an R object (if mode = 'raw', an R vector).}

\item{mode}{[default 'serial'] whether data will be sent serialized or as a
raw vector. Use 'serial' for sending and receiving within R to ensure
perfect reproducibility. Use 'raw' for sending vectors of any type (will be
converted to a raw byte vector for sending) - essential when interfacing
with external applications.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}
}
\value{
A send Aio (object of class 'sendAio').
}
\description{
Send data asynchronously over a Socket or Context.
}
\details{
Async send is always non-blocking and returns immediately.

    To wait for and check the result of the send operation, use
    \code{\link{call_aio}} on the returned 'sendAio' object.

    Alternatively, to stop the async operation, use \code{\link{stop_aio}}.
}
\examples{
pub <- socket("pub", dial = "inproc://nanonext")

aio <- send_aio(pub, data.frame(a = 1, b = 2), timeout = 100)
aio
call_aio(aio)$result

aio <- send_aio(pub, "example message", mode = "raw", timeout = 100)
call_aio(aio)$result

close(pub)

}
