% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socket.R
\name{unsubscribe}
\alias{unsubscribe}
\title{Unsubscribe Topic}
\usage{
unsubscribe(socket, topic = NULL)
}
\arguments{
\item{socket}{a Socket using the sub protocol.}

\item{topic}{[default NULL] a topic (given as a character string). The default
NULL unsubscribes from all topics (if all topics were previously subscribed).}
}
\value{
Zero (invisibly) on success.
}
\description{
For a socket using the sub protocol in a publisher/subscriber pattern. Remove
    a topic from the subscription list.
}
\details{
Note that if the topic was not previously subscribed to then an
    'entry not found' error will result.

    To use pub/sub the publisher must:
    \itemize{
    \item{specify \code{mode = 'raw'} when sending to allow the topics to be
    recognised by the receiving party.}
    \item{send a vector that separates the topic from the rest of the message
    e.g. \code{send(socket, c("topic", "message"), mode = "raw")} - this
    ensures that topic ends with the required null byte for it to be
    recognised.}
    }
}
\examples{
pub <- socket("pub", listen = "inproc://nanonext")
sub <- socket("sub", dial = "inproc://nanonext")

subscribe(sub, NULL)
send(pub, c("examples", "this is an example"), mode = "raw")
recv(sub, "character")
unsubscribe(sub, NULL)
send(pub, c("examples", "this example will not be received"), mode = "raw")
recv(sub, "character")

close(pub)
close(sub)

}
