% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{recv}
\alias{recv}
\title{Receive}
\usage{
recv(
  socket,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw"),
  block = FALSE,
  keep.raw = TRUE
)
}
\arguments{
\item{socket}{a Socket.}

\item{mode}{[default 'serial'] mode of vector to be received - one of 'serial',
'character', 'complex', 'double', 'integer', 'logical', 'numeric', or 'raw'.
The default 'serial' means a serialised R object, for the other modes,
the raw vector received will be converted into the respective mode.}

\item{block}{[default FALSE] logical flag whether to block until successful
or return immediately even if unsuccessful (e.g. nothing to receive).}

\item{keep.raw}{[default TRUE] logical flag whether to keep the received raw
vector (useful for verification e.g. via hashing). If FALSE, will return
the converted data only.}
}
\value{
Named list of 2 elements: 'raw' containing the received raw vector
    and 'data' containing the converted object, or else the converted object
    if 'keep.raw' is set to FALSE.
}
\description{
Receive data over a Socket.
}
\details{
In case of an error, an integer 'errorValue' is returned (to be
    distiguishable from an integer message value). This can be verified using
    \code{\link{is_error_value}}.

    If the raw data was successfully received but an error occurred in
    unserialisation or data conversion (for example if the incorrect mode was
    specified), the received raw vector will always be returned to allow for
    the data to be recovered.
}
\examples{
s1 <- socket("bus", listen = "inproc://nanonext")
s2 <- socket("bus", dial = "inproc://nanonext")

send(s1, data.frame(a = 1, b = 2))
res <- recv(s2)
res
send(s1, data.frame(a = 1, b = 2), echo = FALSE)
recv(s2, keep.raw = FALSE)

send(s1, c(1.1, 2.2, 3.3), mode = "raw")
res <- recv(s2, mode = "double")
res
send(s1, "example message", mode = "raw", echo = FALSE)
recv(s2, mode = "character", keep.raw = FALSE)

close(s1)
close(s2)

}
