% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socket.R
\name{survey_time}
\alias{survey_time}
\title{Set Survey Time}
\usage{
survey_time(socket, time)
}
\arguments{
\item{socket}{a Socket or Context using the surveyor protocol.}

\item{time}{the survey timeout in ms.}
}
\value{
Invisibly, an integer exit code (zero on success).
}
\description{
For a socket using the surveyor protocol in a surveyor/respondent pattern.
    Set a survey timeout in ms (remains valid for all subsequent surveys).
    Messages received by the surveyor after the timer has ended are discarded.
}
\details{
After using this function, to start a new survey, the surveyor must:
    \itemize{
    \item{send a message using any of the send functions.}
    \item{switch to receiving responses.}
    }

    To respond to a survey, the respondent must:
    \itemize{
    \item{receive the survey message.}
    \item{send a reply \emph{using an AIO send function} before the survey
    has timed out (a reply can only be sent after receiving a survey).}
    }
}
\examples{
sur <- socket("surveyor", listen = "inproc://nanonext")
res <- socket("respondent", dial = "inproc://nanonext")
logging(level = "info")

survey_time(sur, 1000)
send(sur, "reply to this survey")
aio <- recv_aio(sur)

recv(res)
s <- send_aio(res, "replied")

call_aio(aio)$data

logging(level = "error")
close(sur)
close(res)

}
