% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{ncurl}
\alias{ncurl}
\title{ncurl}
\usage{
ncurl(
  url,
  async = FALSE,
  convert = TRUE,
  method = NULL,
  headers = NULL,
  data = NULL,
  request = NULL,
  pem = NULL
)
}
\arguments{
\item{url}{the URL address.}

\item{async}{[default FALSE] logical value whether to perform actions async.}

\item{convert}{[default TRUE] logical value whether to attempt conversion of
the received raw bytes to a character vector.}

\item{method}{(optional) the HTTP method (defaults to 'GET' if not specified).}

\item{headers}{(optional) a named list or character vector specifying the
HTTP request headers e.g. \code{list(`Content-Type` = "text/plain")} or
\code{c(Authorization = "Bearer APIKEY")}.}

\item{data}{(optional) the request data to be submitted.}

\item{request}{(optional) a character vector or list specifying the response
headers to request e.g. \code{c("date", "server")} or \code{list("Date", "Server")}.
These are case-insensitive and will return NULL if not present.}

\item{pem}{(optional) applicable to secure HTTPS sites only. The path to a
file containing X.509 certificate(s) in PEM format, comprising the
certificate authority certificate chain (and revocation list if present).
If missing or NULL, certificates are not validated.}
}
\value{
Named list of 4 elements:
    \itemize{
    \item{\code{$status}} {- integer HTTP repsonse status code (200 - OK).}
    \item{\code{$headers}} {- named list of response headers supplied in
    'request' or NULL if unspecified.}
    \item{\code{$raw}} {- raw vector of the received resource (use
    \code{\link{writeBin}} to save to a file).}
    \item{\code{$data}} {- converted character string (if \code{'convert' = TRUE}
    and content is a recognised text format), or NULL otherwise. Other tools
    can be used to further parse this as html, json, xml etc. if required.}
    }

    Or else, if \code{async = TRUE}, an 'ncurlAio' (object of class 'ncurlAio'
    and 'recvAio').
}
\description{
nano cURL - a minimalist http(s) client.
}
\section{Redirects}{


    In interactive sessions: will prompt upon receiving a redirect location
    whether to follow or not (default: yes).

    In non-interactive sessions: redirects are never followed.

    For async requests, the redirect address will be returned as a character
    string at \code{$raw} and \code{$data} will be NULL.
}

\examples{
ncurl("https://httpbin.org/get", request = c("date", "server"))
ncurl("http://httpbin.org/put",,,"PUT", list(Authorization = "Bearer APIKEY"), "hello world")
ncurl("http://httpbin.org/post",,,"POST", c(`Content-Type` = "application/json"),'{"k":"v"}')

}
