% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{send}
\alias{send}
\title{Send}
\usage{
send(con, data, mode = c("serial", "raw"), block = NULL, ...)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{data}{an object (a vector, if mode = 'raw').}

\item{mode}{[default 'serial'] for sending serialised R objects, or 'raw' for
sending vectors of any type (converted to a raw byte vector for sending).
For Streams, 'raw' is the only option and this argument is ignored. Use
'serial' for perfect reproducibility within R, although 'raw' must be used
when interfacing with external applications that do not understand R
serialisation.}

\item{block}{[default NULL] which applies the connection default (see section
'Blocking' below). Specify logical TRUE to block until successful or FALSE
to return immediately even if unsuccessful (e.g. if no connection is
available), or else an integer value specifying the maximum time to block
in milliseconds, after which the operation will time out.}

\item{...}{not used.}
}
\value{
Invisibly, an integer exit code (zero on success).
}
\description{
Send data over a connection (Socket, Context or Stream).
}
\section{Blocking}{


    For Sockets: the default behaviour is non-blocking with \code{block = FALSE}.
    This will return immediately with an error if the message could not be
    queued for sending. Certain protocol / transport combinations may limit
    the number of messages that can be queued if they have yet to be received.

    For Contexts and Streams: the default behaviour is blocking with
    \code{block = TRUE}. This will wait until the send has completed. Set a
    timeout in this case to ensure that the function returns under all scenarios.
    As the underlying implementation uses an asynchronous send with a wait,
    it is recommended to set a positive integer value for \code{block} rather
    than FALSE.
}

\examples{
pub <- socket("pub", dial = "inproc://nanonext")

send(pub, data.frame(a = 1, b = 2))
send(pub, c(10.1, 20.2, 30.3), mode = "raw", block = 100)

close(pub)

req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctx <- context(req)
send(ctx, data.frame(a = 1, b = 2), block = 100)

msg <- recv_aio(rep, timeout = 100)
send(ctx, c(1.1, 2.2, 3.3), mode = "raw", block = 100)

close(req)
close(rep)

}
