% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xfinity_driver_season.R
\docType{data}
\name{xfinity_driver_season}
\alias{xfinity_driver_season}
\title{NASCAR Xfinity Series Driver Season Statistics}
\format{
A data frame with 5,394 rows and 26 variables:
\describe{
\item{season}{num: Racing season (1982-2023)}
\item{driver}{chr: Driver's name}
\item{season_races}{num: Total number of races driven in the season}
\item{season_wins}{num: Total number of wins in the season}
\item{season_win_pct}{num: Win percentage for the season}
\item{season_top_5}{num: Total number of top 5 finishes in the season}
\item{season_top_5_pct}{num: Percentage of top 5 finishes in the season}
\item{season_top_10}{num: Total number of top 10 finishes in the season}
\item{season_top_10_pct}{num: Percentage of top 10 finishes in the season}
\item{season_top_20}{num: Total number of top 20 finishes in the season}
\item{season_top_20_pct}{num: Percentage of top 20 finishes in the season}
\item{season_avg_start}{num: Average start position for the season}
\item{season_best_start}{num: Best start position in the season}
\item{season_worst_start}{num: Worst start position in the season}
\item{season_avg_finish}{num: Average finish position for the season}
\item{season_best_finish}{num: Best finish position in the season}
\item{season_worst_finish}{num: Worst finish position in the season}
\item{season_avg_laps_led}{num: Average number of laps led per race in the season}
\item{season_total_laps_led}{num: Total number of laps led in the season}
\item{season_most_laps_led}{num: Most laps led in a single race in the season}
\item{season_avg_points}{num: Average points earned per race in the season}
\item{season_avg_playoff_pts}{num: Average playoff points earned per race in the season}
\item{season_total_money}{num: Total earnings for the season (in dollars)}
\item{season_avg_money}{num: Average earnings per race for the season (in dollars)}
\item{season_max_race_money}{num: Highest earnings in a single race for the season (in dollars)}
\item{season_min_race_money}{num: Lowest earnings in a single race for the season (in dollars)}
}
}
\source{
\url{https://www.driveraverages.com/nascar_xfinityseries/}

\url{https://en.wikipedia.org/wiki/NASCAR_Xfinity_Series}
}
\usage{
xfinity_driver_season
}
\description{
A collection of season statistics for drivers in the NASCAR Xfinity Series. The data includes season averages and totals for various performance metrics.
}
\examples{
data(xfinity_driver_season)
}
\keyword{datasets}
