% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/templatebrain.R
\name{templatebrain}
\alias{templatebrain}
\title{Construct templatebrain object for an image registration template}
\usage{
templatebrain(name, regName = name, type = NULL, sex = NULL,
  dims = NULL, BoundingBox = NULL, voxdims = NULL, units = NULL,
  description = NULL, doi = NULL, ...)
}
\arguments{
\item{name}{the full name of the template.}

\item{regName}{the short name. This will be the stem used to prefix
registrations (e.g. JFRC2_someimage.list) for this template brain and
likely also the stem of the template brain image (e.g. JFRC2.nrrd).}

\item{type}{one of \code{c('single brain', 'average')}, indicating whether
the template brain has been created from just one image, or is the average
of multiple images.}

\item{sex}{the sex of the template brain. For templates with
\code{type=='average'}, the possibility of \code{sex='intersex'} exists.}

\item{dims}{dimensions of the image (number of voxels).}

\item{BoundingBox}{physical dimensions of the image (see
\code{\link[nat]{boundingbox}}).}

\item{voxdims}{physical spacing between voxels.}

\item{units}{units of physical measurements (e.g. microns).}

\item{description}{details of the template.}

\item{doi}{a DOI for the original template brain image.}

\item{...}{additional named arguments that will be added as fields to the
\code{templatebrain} object.}
}
\value{
A list with class \code{templatebrain}.
}
\description{
\code{templatebrain} objects encapsulate key information for the reference
brain in an image registration. Usually this will be a standard template
brain used for many registrations. \strong{It will normally be much more
convenient to use  \code{\link{as.templatebrain}} methods to convert an image
file or an im3d object into a \code{templatebrain}}.
}
\details{
A variety of methods are available to work on \code{templatebrain} objects. See
\code{\link{templatebrain-meths}} for basic methods. The two main functions
that are availavle for using template brains are \code{\link{xform_brain}} and
\code{\link{mirror_brain}}.

\code{templatebrain} objects are only useful for transformation processes
when the \code{BoundingBox} is specified to define the physical extent of the
volume. We use the definition of the Amira 3D visualisation and analysis
software. This corresponds to the \strong{node} centers option in the
\href{http://teem.sourceforge.net/nrrd/format.html}{NRRD format}. The
bounding box can be obtained from NRRD or AmiraMesh format files. See
\code{\link[nat]{boundingbox}} for details.
}
\seealso{
\code{\link{as.templatebrain}}, \code{\link{templatebrain-meths}},
  \code{\link{xform_brain}}, \code{\link{mirror_brain}}.
}

