% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_balance.R
\name{plot_stand_diffs}
\alias{plot_stand_diffs}
\title{Plot standardized differences in means}
\usage{
plot_stand_diffs(sds, type)
}
\arguments{
\item{sds}{Standardized differences generated with \code{\link{get_stand_diffs}}.}

\item{type}{One of the following, stating which standardized differences to plot:
\describe{
  \item{across}{standardized differences across the population}
  \item{strata_avg}{weighted average of the standardized differences within the strata
    (weighted by stratum size)}
  \item{pair}{two facets displaying both
     the previous plots together}
  \item{strata}{list of plots for the standardized differences
     within each stratum}}}
}
\value{
Either a ggplot object or a list of ggplot objects (if \code{type} is 'strata')
}
\description{
Used within the \code{\link{check_balance}} function to plot the standardized differences calculated
in the format of Love (2002).
}
\references{
Love, T. E. (2002), "Displaying covariate balance after adjustment for selection bias",
Joint Statistical Meetings, yumpu.com/en/document/read/41664623.
}
\keyword{internal}
