% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_optimize_controls_inputs.R
\name{verify_inputs}
\alias{verify_inputs}
\title{Verify the inputs to \code{\link{optimize_controls}()}}
\usage{
verify_inputs(X, importances, ratio, q_s, st, z, treated, integer, solver)
}
\arguments{
\item{X}{a matrix or data frame containing constraints in the columns. The number
of rows should equal the length of \code{z}. Balance is achieved when a constraint
sums to 0, such that numbers closer to 0 are better. When a constraint
does not apply to a particular unit, the entry should be \code{NA}.
This should typically be generated using \code{\link{generate_constraints}()}.}

\item{importances}{a vector with length equal to the number of constraints or columns
in \code{X}. This can be generated using \code{\link{generate_constraints}()} and each nonnegative value
denotes how much to prioritize each constraint, with the default being 1
for all constraints.}

\item{ratio}{a numeric or vector specifying the desired ratio of controls to `treated` in
each stratum. If there is one control group and all treated units should be included,
this can be a numeric. Otherwise, this should be
a vector with one entry per treatment group, in the same order as the levels of
\code{z}, including the treated level. If \code{NULL}, \code{q_s} should be specified.}

\item{q_s}{a named vector or matrix indicating how many units are to be selected from each stratum.
If there is one control group and all treated units are desired, this can be a vector; otherwise,
this should have one row per treatment group, where the order of the rows matches the order of
the levels of \code{z}, including the treated level.
If \code{NULL}, \code{ratio} should be specified. If both are specified, \code{q_s} will take priority.
Typically, if the desired ratio is not feasible for every stratum, \code{q_s} should be generated
using \code{\link{generate_qs}()}.}

\item{st}{a stratum vector with the \code{i}th entry equal to the
stratum of unit \code{i}. This should have the same order of units and length
as \code{z}.}

\item{z}{a factor with the \code{i}th entry equal to the treatment of unit \code{i}.}

\item{treated}{which treatment value should be considered the treated units. This
must be one of the values of \code{z}.}

\item{integer}{a logical stating whether to use a mixed integer programming solver
instead of randomized rounding. Default is \code{FALSE}.}

\item{solver}{a character stating which solver to use to run the linear program.
Options are "Rglpk" (default) or "gurobi". You must have the 'gurobi' package
installed to use the "gurobi" option. If available, this is the recommended solver.}
}
\value{
No return value. If there is a problem with the inputs to \code{\link{optimize_controls}()},
an error is raised.
}
\description{
Makes sure that the inputs to \code{\link{optimize_controls}()} are in the correct
format and feasible.
}
\keyword{internal}
