% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_optimize_controls_inputs.R
\name{verify_multi_comp_inputs}
\alias{verify_multi_comp_inputs}
\title{Verify the inputs for supplemental comparisons to \code{\link{optimize_controls}()}}
\usage{
verify_multi_comp_inputs(
  q_s,
  q_star_s,
  n_s,
  treated,
  treated_star,
  weight_star,
  group,
  correct_sizes
)
}
\arguments{
\item{q_s}{a named vector or matrix indicating how many units are to be selected from each stratum.
If there is one control group and all treated units are desired, this can be a vector; otherwise,
this should have one row per treatment group, where the order of the rows matches the order of
the levels of \code{z}, including the treated level.
If \code{NULL}, \code{ratio} should be specified. If both are specified, \code{q_s} will take priority.
Typically, if the desired ratio is not feasible for every stratum, \code{q_s} should be generated
using \code{\link{generate_qs}()}.}

\item{q_star_s}{a named vector or matrix,
indicating how many supplemental units are to be selected from each stratum.
The matrix should have one row per treatment group, where the order of the rows matches the order of
the levels of \code{z}, including the treated level.
If multiple supplemental comparisons are desired, this should be a list with one entry per supplemental
comparison.}

\item{treated}{which treatment value should be considered the treated units. This
must be one of the values of \code{z}.}

\item{treated_star}{which treatment value should be considered the treated units
for the supplemental comparison. This
must be one of the values of \code{z}.
 If multiple supplemental comparisons are desired, this should be a vector with one entry per supplemental
  comparison.}

\item{weight_star}{a numeric stating how much to prioritize balance between the supplemental units as
compared to balance between the main units.
  If multiple supplemental comparisons are desired, this should be a vector with one entry per supplemental
  comparison.}

\item{correct_sizes}{boolean stating whether the desired sample sizes should
be exactly correct (if \code{correct_sizes = TRUE}) or only need to be correct
in expectation. For multiple comparisons, sample sizes may only be
correct in expectation.}
}
\value{
No return value. If there is a problem with the inputs to \code{\link{optimize_controls}()},
an error is raised.
}
\description{
Makes sure that the inputs for supplemental comparisons to \code{\link{optimize_controls}()} are in the correct
format and feasible.
}
\keyword{internal}
