% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeResults.R
\name{nbHeatmap}
\alias{nbHeatmap}
\title{Plots a heatmap of the relative transmission probabilities}
\usage{
nbHeatmap(
  df,
  indIDVar,
  dateVar,
  pVar,
  clustMethod = c("none", "n", "kd", "hc_absolute", "hc_relative"),
  cutoff = NA,
  blackAndWhite = FALSE,
  probBreaks = c(-0.01, 0.001, 0.005, 0.01, 0.05, 0.1, 0.25, 0.5, 0.75, 1)
)
}
\arguments{
\item{df}{The name of the dateset with transmission probabilities (column \code{pVar}),
individual IDs (columns \code{<indIDVar>.1} and \code{<indIDVar>.2}), and the dates of
observation (columns \code{<dateVar>.1} and \code{<dateVar>.2}).}

\item{indIDVar}{The name (in quotes) of the individual ID columns
(data frame \code{df} must have variables called \code{<indIDVar>.1}
 and \code{<indIDVar>.2}).}

\item{dateVar}{The name (in quotes) of the columns with the dates that the individuals are
observed (data frame \code{df} must have variables called \code{<dateVar>.1} and
\code{<dateVar>.2}).}

\item{pVar}{The name (in quotes) of the column with transmission probabilities.}

\item{clustMethod}{The method used to cluster the infectors; one of 
\code{"none", "n", "kd", "hc_absolute", "hc_relative"} where \code{"none"} or
not specifying a value means use all pairs with no clustering
(see \code{\link{clusterInfectors}} for detials on clustering methods).}

\item{cutoff}{The cutoff for clustering (see \code{\link{clusterInfectors}}).}

\item{blackAndWhite}{A logical. If \code{TRUE}, then the squares are colored in greyscale,
if \code{FALSE}, then the squares are colored with shades of blue.}

\item{probBreaks}{A numeric vector containing between 3 and 10 elements specifying the
boundaries used to classify the probabilities and color the squares.
The first element should be less than 0 and the last should be 1.}
}
\description{
The function \code{nbHeatmap} plots a heatmap of the transmission probabilities.
The rows are the possible infectors and the columns are the possible infectees both
ordered by \code{<dateVar>}. The darker the square the higher the probability that
the pair represented by that square is a transmission link. If a cluster method is specified 
using \code{clustMethod} and \code{cutoff}, then stars will be drawn in the squares of the
infectors in the top cluster.
}
\details{
Users have the option of specifying how the probabilities should be grouped into different
color shades through the argument \code{probBreaks}. The probabilities are split into groups by
using \code{probBreaks} as the \code{breaks} argument in \code{\link[base]{cut}} with the default options.
The length of the vector should be between 3 and 10 and the first element should be less than 0 and 
the last 1 so that all probabilities are guarenteed to be classified.
The colors are defined with the code \code{brewer.pal(length(probBreaks) - 1, "Blues")}
(where "Blues" is replaced by "Greys" if \code{blackAndWhite} is set to \code{TRUE}).

\strong{NOTE: This plot will take long to run and may not look good with
 larger outbreaks (>200 individuals)}
}
\examples{

\donttest{
## Heatmap with no clustering in color with the default probability breaks
par(mar = c(0, 0, 1, 0))
nbHeatmap(nbResults, indIDVar = "individualID", dateVar = "infectionDate",
pVar = "pScaled", clustMethod = "none")
dev.off() 


## Adding stars for the top cluster, in black and white, changing the probability breaks
par(mar = c(0, 0, 1, 0))
nbHeatmap(nbResults, indIDVar = "individualID", dateVar = "infectionDate",
          pVar = "pScaled", clustMethod = "hc_absolute", cutoff = 0.05,
          blackAndWhite = TRUE, probBreaks = c(-0.01, 0.01, 0.1, 0.25, 0.5, 1))
dev.off()
}


}
\seealso{
\code{\link{nbProbabilities}} \code{\link{clusterInfectors}}
}
