% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_help.R
\name{nbc4vaHelpMethods}
\alias{nbc4vaHelpMethods}
\title{Methodology and implementation in nbc4va}
\usage{
nbc4vaHelpMethods()
}
\description{
Methodology and implementation in nbc4va
}
\section{About}{

This documentation page provides details on the implementation of the Naive Bayes Classifier algorithm,
definition of uncommon terms, and calculation of performance metrics.
}

\section{Naive Bayes Classifier}{

The Naive Bayes Classifier (NBC) is a machine learning algorithm that uses training data containing
cases of deaths to learn probabilities for known causes of death based on given symptoms.
This produces a model that can use the learned probabilities to predict
the cause of death for cases in unseen testing data with same symptoms. \cr \cr
The nbc4va package implements the NBC algorithm for verbal autopsy data using code and methods built on \href{http://bmcmedicine.biomedcentral.com/articles/10.1186/s12916-015-0521-2}{Miasnikof \emph{et al} (2015)}.
}

\section{Terms for Data}{

\itemize{
  \item \strong{Symptom}: Refers to the features or independent variables with binary values of 1 for presence and 0 for absence of a death related condition
  \item \strong{Cause}: Refers to the target or dependent variable containing discrete values of the causes of death
  \item \strong{Case}: Refers to an individual death containing an identifier, a cause of death (if known), and several symptoms
  \item \strong{Training Data}: Refers to a dataset of cases that the NBC algorithm learns probabilities from
  \item \strong{Testing Data}: Refers to a dataset of cases used to evaluate the performance of a NBC model; these cases must have the same symptoms as the \emph{Training Data}, but with different cases
}
}

\section{Terms for Metrics}{

\itemize{
  \item \strong{True Positives}: The number of cases, given a cause, where the predicted cause is equal to the actual observed cause \href{http://people.inf.elte.hu/kiss/13dwhdm/roc.pdf}{(Fawcett, 2005)}.
  \item \strong{True Negatives}: The number of cases, given a cause, where the predicted is not the cause and the actual observed is also not the cause \href{http://people.inf.elte.hu/kiss/13dwhdm/roc.pdf}{(Fawcett, 2005)}.
  \item \strong{False Positives}: The number of cases, given a cause, where the predicted is the cause and the actual observed is not the cause \href{http://people.inf.elte.hu/kiss/13dwhdm/roc.pdf}{(Fawcett, 2005)}.
  \item \strong{False Negatives}: The number of cases, given a cause, where the predicted is not the cause and the actual observed is the cause \href{http://people.inf.elte.hu/kiss/13dwhdm/roc.pdf}{(Fawcett, 2005)}.
  \item \strong{CSMF}: The fraction of deaths (predicted or observed) for a particular cause.
}
}

\section{Calculation of Metrics at the Individual Level}{

The following metrics measure the performance of a model by comparing its predicted causes individually
to the matching true/observed causes.
\itemize{
  \item \strong{Sensitivity}: proportion of correctly identified positives \href{https://dl.dropboxusercontent.com/u/27743223/201101-Evaluation_JMLT_Postprint-Colour.pdf}{(Powers, 2011)}.
    \cr \cr \figure{eqsensitivity.png}
    \itemize{
      \item \eqn{TP} is the number of true positives
      \item \eqn{FN} is the number of false negatives
      \item This metric measures a model's ability to correctly predict causes of death
    }
  \item \strong{PCCC}: partial chance corrected concordance \href{http://pophealthmetrics.biomedcentral.com/articles/10.1186/1478-7954-9-28}{(Murray \emph{et al} 2011)}.
    \cr \cr \figure{eqpccc.png}
    \itemize{
      \item \eqn{C} is the fraction of deaths where the true cause is in the top \eqn{k} causes assigned to that death
      \item \eqn{k} is the number of top causes (constant of 1 in this package)
      \item \eqn{N} is the number of causes in the study
      \item This metric measures how much better a model is than random assignment
    }
}
}

\section{Calculation of Metrics at the Population Level}{

The following metrics measure the performance of a model by comparing its distribution of cause predictions to
a distribution of true/observed causes for similar cases.
\itemize{
  \item \strong{CSMFmaxError}: cause specific mortality fraction maximum error \href{http://pophealthmetrics.biomedcentral.com/articles/10.1186/1478-7954-9-28}{(Murray \emph{et al} 2011)}.
    \cr \cr \figure{eqcsmfmaxerror.png}
    \itemize{
      \item \eqn{j} is a true/observed cause
      \item \eqn{CSMFtruej} is the true/observed CSMF for cause j
    }
  \item \strong{CSMFaccuracy}: cause specific mortality fraction accuracy \href{http://pophealthmetrics.biomedcentral.com/articles/10.1186/1478-7954-9-28}{(Murray \emph{et al} 2011)}.
    \cr \cr \figure{eqcsmfaccuracy.png}
    \itemize{
      \item \eqn{j} is a cause
      \item \eqn{CSMFtruej} is the true/observed CSMF for cause j
      \item \eqn{CSMFpredj} is the predicted CSMF for cause j
      \item Values range from 0 to 1 with 1 meaning no error in the predicted CSMFs, and 0 being complete error in the predicted CSMFs
    }
}
}
\references{
\itemize{
  \item Fawcett T. An introduction to ROC analysis. Pattern Recognition Letters[Internet]. 2005 Dec 19[cited 2016 Apr 29];27(8):861-874. Available from: http://people.inf.elte.hu/kiss/13dwhdm/roc.pdf
  \item Miasnikof P, Giannakeas V, Gomes M, Aleksandrowicz L, Shestopaloff AY, Alam D, Tollman S, Samarikhalaj, Jha P. Naive Bayes classifiers for verbal autopsies: comparison to physician-based classification for 21,000 child and adult deaths. BMC Medicine. 2015;13:286. doi:10.1186/s12916-015-0521-2.
  \item Murray CJL, Lozano R, Flaxman AD, Vahdatpour A, Lopez AD. Robust metrics for assessing the performance of different verbal autopsy cause assignment methods in validation studies.Popul Health Metr. 2011;9:28. doi:10.1186/1478-7954-9-28.
  \item Powers DMW. EVALUATION: FROM PRECISION, RECALL AND F-MEASURE TO ROC, INFORMEDNESS, MARKEDNESS & CORRELATION. Journal of Machine Learning Technologies. 2011;2(1)37-63.
}
}
\seealso{
Guide for package: \code{\link{nbc4va}}

Other help functions: \code{\link{nbc4vaHelpAdvanced}},
  \code{\link{nbc4vaHelpBasic}},
  \code{\link{nbc4vaHelpData}},
  \code{\link{nbc4vaHelpDev}},
  \code{\link{nbc4vaHelpFunctions}},
  \code{\link{nbc4vaHelp}}
}

