% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfObject.R, R/ncdfDimension.R,
%   R/ncdfVariable.R, R/ncdfDataset.R, R/ncdfDimensionCharacter.R,
%   R/ncdfDimensionNumeric.R, R/ncdfDimensionTime.R
\name{showObject}
\alias{showObject}
\alias{shard,ncdfDimension-method}
\alias{show,ncdfVariable-method}
\alias{brief,ncdfVariable-method}
\alias{shard,ncdfVariable-method}
\alias{show,ncdfDataset-method}
\alias{brief,ncdfDataset-method}
\alias{show,ncdfDimensionCharacter-method}
\alias{brief,ncdfDimensionCharacter-method}
\alias{show,ncdfDimensionNumeric-method}
\alias{brief,ncdfDimensionNumeric-method}
\alias{show,ncdfDimensionTime-method}
\alias{brief,ncdfDimensionTime-method}
\title{Summary of object details}
\usage{
\S4method{shard}{ncdfDimension}(object)

\S4method{show}{ncdfVariable}(object)

\S4method{brief}{ncdfVariable}(object)

\S4method{shard}{ncdfVariable}(object)

\S4method{show}{ncdfDataset}(object)

\S4method{brief}{ncdfDataset}(object)

\S4method{show}{ncdfDimensionCharacter}(object)

\S4method{brief}{ncdfDimensionCharacter}(object)

\S4method{show}{ncdfDimensionNumeric}(object)

\S4method{brief}{ncdfDimensionNumeric}(object)

\S4method{show}{ncdfDimensionTime}(object)

\S4method{brief}{ncdfDimensionTime}(object)
}
\arguments{
\item{object}{The \code{ncdfObject} to show.}
}
\value{
\code{show()} prints information to the console. \code{brief()} returns a
1-row \code{data.frame} with some details of \code{object}. \code{shard()} returns a
character string with a few identifying details of \code{object}.
}
\description{
These methods provide information on the various \code{ncdfCF}
objects. While the individual methods are generally behaving the same for
all descendant classes, there are some differences related to the nature of
the objects.
\itemize{
\item Method \code{show()} will provide many details of the object over multiple
lines printed to the console. This includes all attributes so it could be a
substantive amount of information.
\item Method \code{brief()} returns some details of the object in a 1-row \code{data.frame}
for further processing, such as combining details from all variables of a
dataset into a single table.
\item Method \code{shard()} returns a very short character string with some identifying
properties of the object, typically only useful when combined with shards
of other object to provide a succinct overview of the dataset. This method
has limited usability for the user but may be of interest for programmatic
access.
}
}
\examples{
fn <- system.file("extdata", "ERA5land_Rwanda_20160101.nc", package = "ncdfCF")
ds <- open_ncdf(fn)

# ncdfDataset, show
ds

# ncdfDataset, brief
# Note that the variables and dimensions are described by shards
brief(ds)

# ncdfVariable, show
pev <- ds[["pev"]]
pev

# ncdfDimensionNumeric, shard
lon <- ds[["longitude"]]
shard(lon)
}
