% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDendrogram.R
\name{plotDendrogram}
\alias{plotDendrogram}
\title{Plot Dendrogram}
\usage{
plotDendrogram(dend, results, labelsCex, pCex, pAlpha = 0.95,
  showSign = TRUE, dendTitle = paste("Cluster Dendrogram with AU/BP values",
  "(\%)\\n AU Values Highlighted by Signif"))
}
\arguments{
\item{dend}{The dendrogram object to plot.}

\item{results}{The results of the hierarchical clustering analysis performed
on the data.}

\item{labelsCex}{The font size of the labels of the dendrogram.}

\item{pCex}{The font size of the p-value labels of the dendrogram.}

\item{pAlpha}{The level of significance chosen to detect significant clusters.}

\item{showSign}{A boolean indicating whether or not to add the p-values to the
dendrogram.}

\item{dendTitle}{The title of the dendrogram plot.}
}
\value{
The dendrogram with the statistical analysis provided 
  by \link{pvclust}.
}
\description{
\code{plotDendrogram} plots the dendrogram of the results of the analysis
  performed by the neatmap function.
}
\examples{
df <- netsDataFrame(net.attr.df = networkAttrDF,
                    node.attr.df = nodeAttrDF,
                    edge.df = edgeDF)
results <- neatmap(df, scale.df = "basic", mainTitle = "Heatmap", 
                    xlabel = "Chararacteritics", ylabel = "Networks",
                    link.method = "single", dist.method = "euclidean",
                    nBootRep = 10)
dendrogram <- results[[1]]
pvclustResults <- results[[3]]
dend <- plotDendrogram(dend = dendrogram, results = pvclustResults,
                       labelsCex = 0.5, pCex = 0.60, pAlpha = 0.95)

}
\author{
Phil Boileau , \email{philippe.boileau@mail.concordia.ca}
}
