% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterTweetsMachineLearning.R
\name{filterTweetsMachineLearning}
\alias{filterTweetsMachineLearning}
\title{Classify needs based on machine learning}
\usage{
filterTweetsMachineLearning(dataToClassify, trainingData)
}
\arguments{
\item{dataToClassify}{a dataframe containing the Tweet messages to classify}

\item{trainingData}{a dataframe containing Tweets messages with a given classification (0=not a need, 1=a need)}
}
\value{
a dataframe with classified data
}
\description{
\code{filterTweetsMachineLearning} classifies a list of Tweets as
needs based on the random forest machine learning algorithm
}
\details{
This function uses a machine learning algorithm (random forest) to
classify needs based on their content. It needs a training data set
with classified needs (indicated by 0=not a need, 1=a need).
This function used code fragments from the archived R packages 
maxent and RTextTools. The authors are Timothy P. Jurka, Yoshimasa Tsuruoka, 
Loren Collingwood, Amber E. Boydstun, Emiliano Grossman, Wouter van Atteveldt
}
\examples{
data(NMTrainingData)
data(NMdataToClassify)
smallNMTrainingData <- rbind(NMTrainingData[1:75,], NMTrainingData[101:175,])
smallNMdataToClassify <- rbind(NMdataToClassify[1:10,], NMdataToClassify[101:110,])
results <- filterTweetsMachineLearning(smallNMdataToClassify, smallNMTrainingData)

}
\author{
Dorian Proksch <dorian.proksch@hhl.de>
}
