% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterTweetNeedwords.R
\name{filterTweetsNeedwords}
\alias{filterTweetsNeedwords}
\title{Filter tweets containing need indicating words}
\usage{
filterTweetsNeedwords(tweetMessages, needWords)
}
\arguments{
\item{tweetMessages}{a dataframe containing the Tweet messages}

\item{needWords}{a string containing needwords separately by ';'}
}
\value{
a filtered data frame
}
\description{
\code{filterTweetsNeedwords} filters a list of Tweets regarding
need indicating words
}
\details{
This function filters Tweets regarding a list of need indicating words
}
\examples{
data(NMTrainingData)
needWordsNeedsOnly <- "need;want;wish;feature;ask;would like;improve;idea;upgrade"
needsSimple <- filterTweetsNeedwords(NMTrainingData, needWordsNeedsOnly)
needWordsExtended <- "need;want;wish;feature;ask;would like;improve;idea;upgrade;
					support;problem;issue;help;fix;complain;fail"
needsSimpleExtended <- filterTweetsNeedwords(NMTrainingData, needWordsExtended)
}
\author{
Dorian Proksch <dorian.proksch@hhl.de>
}
