% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RL.R
\name{RL}
\alias{RL}
\title{Relocating Links algorithm (RL algorithm)}
\usage{
RL(ideal.net, initial.net, triads = "forb", k = 100, custom.triads = NULL)
}
\arguments{
\item{ideal.net}{Network with a desired blockmodel without inconsistencies; of class \code{matrix}.}

\item{initial.net}{Initial network; of class \code{matrix}.}

\item{triads}{What types of triads has to be considered (allowed \code{allow}, forbidden \code{forb}, all \code{all} or custom \code{cust}). Provide a list of triad types as used in package ergm.}

\item{k}{Number of iterations.}

\item{custom.triads}{A list with names of a subset of triads to be considered. The same names must be used as in ERGM package. Only if \code{triads = "cust"}.}
}
\value{
A list contiainig: \code{new.network} which is the generated network (of class \code{matrix}); and \code{CR} which is
a vector of CR values (calculated after each iteration).
}
\description{
It generates random network considering the selected types of triads.
}
\examples{
# generate initial and ideal network
cohesiveBM <- rbind(c("com", "nul"), c("nul", "com"))
ideal <- genNetworkLE(BM = cohesiveBM, LE = 0, size = c(4, 4))
random <- genNetworkLE(BM = cohesiveBM, LE = 1, size = c(4, 4))
# generate network with the RL algorithm
generatedNetwork <- RL(ideal.net = ideal, initial.net = random, triads = "all", k = 10)
}
\references{
Cugmas M, Ferligoj A, Žiberna A (2018) Generating global network structures by triad types. PLoS ONE 13(5): e0197514. https://doi.org/10.1371/journal.pone.0197514
}
\author{
Marjan Cugmas and Aleš Žiberna
}
