% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airway_05_population.R
\name{airway_05_population}
\alias{airway_05_population}
\title{Airway-05 Population}
\usage{
airway_05_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  arrest_table = NULL,
  procedures_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  earrest_01_col,
  eresponse_05_col,
  evitals_01_col,
  evitals_12_col,
  eprocedures_01_col,
  eprocedures_02_col,
  eprocedures_03_col
)
}
\arguments{
\item{df}{A dataframe or tibble contianing EMS data where each row represents
an observation and columns represent features. Default is \code{NULL}.}

\item{patient_scene_table}{A data.frame or tibble containing at least
epatient, escene, and earrest.01 fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data.frame or tibble containing at least the
eresponse fields needed for this measure's calculations. Default is \code{NULL}.}

\item{arrest_table}{A data.frame or tibble containing at least the earrest
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{procedures_table}{A dataframe or tibble containing at least the
eProcedures fields needed. Default is \code{NULL}.}

\item{vitals_table}{A dataframe or tibble containing at least the eVitals
fields needed. Default is \code{NULL}.}

\item{erecord_01_col}{The column representing the EMS record unique
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column representing the patient's numeric age agnostic
of unit.}

\item{epatient_16_col}{Column representing the patient's age unit ("Years",
"Months", "Days", "Hours", or "Minutes").}

\item{earrest_01_col}{Column representing whether or not the patient is in
arrest.}

\item{eresponse_05_col}{Column that contains eResponse.05.}

\item{evitals_01_col}{Date-time or POSIXct column containing vital signs
date/time}

\item{evitals_12_col}{Numeric column containing pulse oximetry values.}

\item{eprocedures_01_col}{Date-time or POSIXct column for procedures}

\item{eprocedures_02_col}{Column name for whether or not the procedure was
performed prior to EMS care being provided.}

\item{eprocedures_03_col}{Column containing procedure codes with or without
procedure names.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
This function processes and analyzes the dataset to generate the populations
of interest needed to perform calculations to obtain performance data.
}
\examples{

# If you are sourcing your data from a SQL database connection
# or if you have your data in several different tables,
# you can pass table inputs versus a single data.frame or tibble

# create tables to test correct functioning

  # patient table
  patient_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    incident_date = rep(as.Date(c("2025-01-01", "2025-01-05", "2025-02-01",
    "2025-01-01", "2025-06-01")), 2),
    patient_dob = rep(as.Date(c("2000-01-01", "2020-01-01", "2023-02-01",
                                "2023-01-01", "1970-06-01")), 2),
    epatient_15 = rep(c(25, 5, 2, 2, 55), 2),  # Ages
    epatient_16 = rep(c("Years", "Years", "Years", "Years", "Years"), 2)

  )

  # response table
  response_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    eresponse_05 = rep(2205001, 10)

  )

  # vitals table
  vitals_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    evitals_01 = lubridate::as_datetime(c("2025-01-01 22:59:00",
    "2025-01-05 11:58:00", "2025-02-01 18:57:00", "2025-01-01 04:58:00",
    "2025-06-01 12:57:00", "2025-01-01 23:05:00", "2025-01-05 12:04:00",
    "2025-02-01 19:03:00", "2025-01-01 05:02:00", "2025-06-01 13:01:00")),
    evitals_12 = rep(c(90, 91, 92, 93, 94), 2)

  )

# arrest table
  arrest_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    earrest_01 = rep("No", 10)
  )

  # procedures table
  procedures_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    eprocedures_01 = rep(lubridate::as_datetime(c("2025-01-01 23:00:00",
    "2025-01-05 12:00:00", "2025-02-01 19:00:00", "2025-01-01 05:00:00",
    "2025-06-01 13:00:00")), 2),
    eprocedures_02 = rep("No", 10),
    eprocedures_03 = rep(c(16883004, 112798008, 78121007, 49077009,
                           673005), 2)

  )

# Run the function
result <- airway_05_population(df = NULL,
         patient_scene_table = patient_table,
         procedures_table = procedures_table,
         vitals_table = vitals_table,
         arrest_table = arrest_table,
         response_table = response_table,
         erecord_01_col = erecord_01,
         incident_date_col = incident_date,
         patient_DOB_col = patient_dob,
         epatient_15_col = epatient_15,
         epatient_16_col = epatient_16,
         eresponse_05_col = eresponse_05,
         eprocedures_01_col = eprocedures_01,
         eprocedures_02_col = eprocedures_02,
         eprocedures_03_col = eprocedures_03,
         earrest_01_col = earrest_01,
         evitals_01_col = evitals_01,
         evitals_12_col = evitals_12
         )

# show the results of filtering at each step
result$filter_process

}
\author{
Samuel Kordik, BBA, BS, Nicolas Foss Ed.D., MS
}
