% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_02.R
\name{safety_02}
\alias{safety_02}
\title{Safety-02 Calculation}
\usage{
safety_02(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  disposition_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  edisposition_18_col,
  edisposition_28_col,
  transport_disposition_cols,
  ...
)
}
\arguments{
\item{df}{A data frame where each row is an observation, and each column
represents a feature.}

\item{patient_scene_table}{A data.frame or tibble containing only epatient
and escene fields as a fact table.}

\item{response_table}{A data.frame or tibble containing only the eresponse
fields needed for this measure's calculations.}

\item{disposition_table}{A data.frame or tibble containing only the
edisposition fields needed for this measure's calculations.}

\item{erecord_01_col}{The column representing the EMS record unique
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column giving the calculated age value.}

\item{epatient_16_col}{Column giving the provided age unit value.}

\item{eresponse_05_col}{Column giving response codes, identifying 911
responses.}

\item{edisposition_18_col}{Column giving transport mode descriptors,
including possible lights-and-sirens indicators.}

\item{edisposition_28_col}{Column giving patient evaluation and care
categories for the EMS response.}

\item{transport_disposition_cols}{One or more unquoted column names (such as
edisposition.12, edisposition.30) containing transport disposition details.}

\item{...}{Additional arguments for summary calculation, if needed.}
}
\value{
A tibble summarizing results for three age groups (< 10 yrs, 10–65
yrs, and >= 65 yrs) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (< 18 yrs, >= 18 yrs, all).
\code{numerator}: Count of incidents from a 911 request during which lights and
sirens were not used during patient transport.
\code{denominator}: Total count of incidents.
\code{prop}:Proportion of incidents from a 911 request during which lights and
sirens were not used during patient transport.
\code{prop_label}: Proportion formatted
as a percentage with a specified number of decimal places.
}
\description{
The \code{safety_02} function calculates the Safety-02 metric, evaluating the
proportion of emergency medical calls involving transport where no lights and
sirens were used. This function categorizes the population into adult and
pediatric groups based on their age, and summarizes results with a total
population count as well.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    edisposition_18 = rep(4218015, 5),
    edisposition_28 = rep(4228001, 5),
    edisposition_30 = rep(4230001, 5)
  )

  # Run function
  safety_02(
    df = test_data,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    edisposition_18_col = edisposition_18,
    edisposition_28_col = edisposition_28,
    transport_disposition_cols = edisposition_30
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
