% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respiratory_01_population.R
\name{respiratory_01_population}
\alias{respiratory_01_population}
\title{Respiratory-01 Populations}
\usage{
respiratory_01_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  evitals_12_col,
  evitals_14_col
)
}
\arguments{
\item{df}{A data frame containing incident data with each row representing an
observation.}

\item{patient_scene_table}{A data.frame or tibble containing at least
epatient and escene fields as a fact table.}

\item{response_table}{A data.frame or tibble containing at least the
eresponse fields needed for this measure's calculations.}

\item{situation_table}{A data.frame or tibble containing at least the
esituation fields needed for this measure's calculations.}

\item{vitals_table}{A data.frame or tibble containing at least the evitals
fields needed for this measure's calculations.}

\item{erecord_01_col}{Unique Patient ID}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column giving the
calculated age value.}

\item{epatient_16_col}{Column giving the
provided age unit value.}

\item{eresponse_05_col}{Column name for
911 response codes (e.g., 2205001, 2205003, 2205009).}

\item{esituation_11_col}{Column name for
primary impression codes related to respiratory distress.}

\item{esituation_12_col}{Column name for
secondary impression codes related to respiratory distress.}

\item{evitals_12_col}{Column name for
the first vital sign measurement.}

\item{evitals_14_col}{Column name for
the second vital sign measurement.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
The \code{respiratory_01_population} function filters and analyzes data related to
emergency 911 respiratory distress incidents, providing the adult, pediatric,
and initial populations. This function uses specific data columns for 911
response codes, primary and secondary impressions, and vital signs to filter
a dataset down to the populations of interest.
}
\examples{
# create tables to test correct functioning

# patient table
patient_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05",
                              "2025-02-01", "2025-01-01",
                              "2025-06-01")
                              ),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01",
                            "2023-02-01", "2023-01-01",
                            "1970-06-01")
                            ),
    epatient_15 = c(25, 5, 2, 2, 55),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Years", "Years")

)

# response table
response_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  eresponse_05 = rep(2205001, 5)

)

# situation table
situation_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  esituation_11 = c(rep("J80", 3), rep("I50.9", 2)),
  esituation_12 = c(rep("J80", 2), rep("I50.9", 3))
)

# vitals table
vitals_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  evitals_12 = c(60, 59, 58, 57, 56),
  evitals_14 = c(16, 15, 14, 13, 12)

)

# Run the function
result <- respiratory_01_population(patient_scene_table = patient_table,
                              response_table = response_table,
                              situation_table = situation_table,
                              vitals_table = vitals_table,
                              erecord_01_col = erecord_01,
                              incident_date_col = incident_date,
                              patient_DOB_col = patient_dob,
                              epatient_15_col = epatient_15,
                              epatient_16_col = epatient_16,
                              eresponse_05_col = eresponse_05,
                              esituation_11_col = esituation_11,
                              esituation_12_col = esituation_12,
                              evitals_12_col = evitals_12,
                              evitals_14_col = evitals_14
                             )

# show the results of filtering at each step
result$filter_process

}
\author{
Nicolas Foss, Ed.D., MS
}
