% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_data_prep.R
\name{npe_heights}
\alias{npe_heights}
\title{Get heights}
\usage{
npe_heights(
  neon_div_object,
  scale = "plot",
  verbose = FALSE,
  timescale = "annual"
)
}
\arguments{
\item{neon_div_object}{the raw diversity data downloaded using
neonPlantEcology::download_plant_div() or the function
neonUtilities::loadByProduct() with the dpID arguement set to "DP1.10058.001".}

\item{scale}{the spatial scale of aggregation. Can be "1m", "10m", "100m",
"plot" or "site". default is "plot".}

\item{verbose}{if true, prints details of which eventID errors were fixed into the console}

\item{timescale}{The temporal scale of aggregation. Can be "all", "annual" or
"subannual" in the case of multiple sampling bouts per year. Defaults to "annual".}
}
\value{
a data frame with each row a single observation of species height at the
spatial and temporal scale chosen by the user.
}
\description{
Get heights
}
\examples{
data("D14")
heights <- npe_heights(D14)
}
