% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_data_prep.R
\name{npe_change_native_status}
\alias{npe_change_native_status}
\title{Change the native status code for a particular taxon at a particular site}
\usage{
npe_change_native_status(df, taxon, site, new_code)
}
\arguments{
\item{df}{is the data frame returned by npe_longform}

\item{taxon}{is the taxonID column in the data frame}

\item{site}{is the identity of the NEON site (e.g. "JORN")}

\item{new_code}{is the NativeStatusCode value to change to}
}
\value{
a data frame
}
\description{
Sometimes even though a particular species identity is not known, the end
user can still determine its native status. For example, maybe the taxon
was identified to the genus level, and the local flora confirms that all
plants in that genus are native at that particular site. This function
allows for post-hoc modification of the native status code for cases like this.
}
\examples{

data("D14")
lf_div <- npe_longform(D14)
modified_lf_div <- npe_change_native_status(lf_div, "ABUTI", "JORN", "N")

}
