% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_download_s3.R
\name{neon_download_s3}
\alias{neon_download_s3}
\title{Download requested NEON files from an S3 bucket}
\usage{
neon_download_s3(
  product,
  start_date = NA,
  end_date = NA,
  site = NA,
  type = "expanded",
  file_regex = "[.]csv",
  quiet = FALSE,
  verify = TRUE,
  dir = neon_dir(),
  unzip = TRUE,
  api = "https://minio.thelio.carlboettiger.info/neonstore/"
)
}
\arguments{
\item{product}{A NEON \code{productCode}. See \link{neon_download}.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{type}{Should we prefer the basic or expanded version of this product?
See details.}

\item{file_regex}{Download only files matching this pattern.  See details.}

\item{quiet}{Should download progress be displayed?}

\item{verify}{Should downloaded files be compared against the MD5 hash
reported by the NEON API to verify integrity? (default \code{TRUE})}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}

\item{unzip}{should we extract .zip files?  Also removes the .zip files.
(default \code{TRUE}).  Set to FALSE if you want to keep \code{.zip} archives and
manually unzip them later.}

\item{api}{URL to an S3 bucket containing raw NEON data files (in
flat file structure like that used by neonstore).}
}
\value{
(invisibly) table of requested files and metadata
}
\description{
Queries the AWS-S3 REST endpoint GET bucket for a file list
in (in 1000-file chunks), then filters file names to determine
what to download. This should be much faster than the NEON API and
avoids rate-limiting.
}
\examples{

\dontshow{
# Users get confused by use of tempdir in examples, so hide
Sys.setenv(NEONSTORE_HOME=tempdir())
}

\donttest{
 neon_download("DP1.10003.001", 
               start_date = "2018-01-01", 
               end_date = "2019-01-01",
               site = "YELL")
}

\dontshow{
 # And clean up
Sys.unsetenv("NEONSTORE_HOME")
}

}
