% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depths.R
\name{depths}
\alias{depths}
\alias{depths.default}
\alias{depths.download}
\alias{depths.download_list}
\title{Extracts the depth values from a `download` object}
\usage{
depths(obj, ...)

\method{depths}{default}(obj, ...)

\method{depths}{download}(obj, ...)

\method{depths}{download_list}(obj, ...)
}
\arguments{
\item{obj}{A \code{download} object.}

\item{...}{argugments passed to other methods.}
}
\value{
Returns a vector of depths.
}
\description{
Using a \code{download} object, return the sample depths (if available).

Using a numeric value, \code{download}, \code{download_list}, \code{dataset} or \code{dataset_list} object, open up a browser window in the users default browser. Very large objects
}
\examples{
\dontrun{
# Provide a vector of depths to generate a new age model:
# The dataset id 684 is for Devils Lake, a record published by Louis Maher Jr.

pollen.data <- get_download(684)
pollen.chron <- get_chroncontrol(pollen.data)[[1]]

age_sds <- pollen.chron$chron.control$age - focal$chron.control$age.young,
get_curves <- ifelse(regexpr("Radiocarbon",
                             pollen.chron$chron.control$control.type) > -1, 
                     'intcal13', 'normal')

new_chron <- Bchron::Bchronology(ages   = pollen.chron$chron.control$age,
                                 ageSds = age_sds
                                 positions = pollen.chron$chron.control$depth,
                                 calCurves = , 
                                 predictPositions = depths(pollen.data))

}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
API Reference:  http://api.neotomadb.org/doc/resources/sites
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\keyword{IO}
\keyword{connection}
