% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_publication.R
\name{get_publication}
\alias{get_publication}
\title{A function to get publications for sites or datasets in the Neotoma Database using the API.}
\usage{
get_publication(x, contactid, datasetid, author, pubtype, year, search)
}
\arguments{
\item{x}{Numeric Publication ID value, either from \code{\link{get_dataset}} or known.}

\item{contactid}{Numeric Contact ID value, either from \code{\link{get_dataset}} or \code{\link{get_contact}}}

\item{datasetid}{Numeric Dataset ID, known or from \code{\link{get_dataset}}}

\item{author}{Character string for full or partial author's name.  Can include wildcards such as 'Smit*' for all names beginning with 'Smit'.}

\item{pubtype}{Character string, one of eleven allowable types, see \code{\link{get_table}}. For a list of allowed types run \code{get_table("PublicationTypes")}.}

\item{year}{Numeric publication year.}

\item{search}{A character string to search for within the article citation.}
}
\value{
A list is returned with two data frame components:

 \item{ \code{meta} }{A single row with Publication ID, type, year of publication and full citation.}
 \item{ \code{Authors} }{\code{data.frame} of author names, order and IDs, can be of variable length.}
}
\description{
The function takes the parameters, defined by the user, and returns a table with publication information from the Neotoma Paleoecological Database.
}
\examples{
\dontrun{
#  To find all publications from 1998:
year.cont <- get_publication(year = 1998)

# To find all data contributors who have the last name "Smith"
smith.cont <- get_publication(author = 'Smith')
}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
API Reference:  http://api.neotomadb.org/doc/resources/contacts
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\keyword{IO}
\keyword{connection}
