% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_downloads.R
\name{get_downloads}
\alias{get_downloads}
\title{get_downloads}
\usage{
get_downloads(x = NA, verbose = TRUE, ...)
}
\arguments{
\item{x}{Use a single number to extract site information}

\item{verbose}{Status bar of items being downloaded}

\item{...}{accepted arguments: sites, datasets}
}
\value{
The function returns either a single item of class
\code{"try-error"} describing the reason for failure
(either misdefined parameters or an error from the Neotoma API),
or a table of sites, with rows corresponding to the number of
individual sites and datasets returned by the Neotoma API.
Each "site" object contains 6 parameters that can be accessed as well:
\item{ \code{siteid} }{site ID number}
\item{ \code{sitename} }{site's name}
\item{ \code{location} }{sf object that describes site's location}
\item{ \code{description} }{}
\item{ \code{collunits} }{limited information on collunits}
Each "collection unit" embedded in the "sites" object contains
6 parameters that can be accessed as well:
\item{ \code{collunitid}}{collection unit ID number}
\item{ \code{handle} }{collection unit's handle}
\item{ \code{collunitname} }{collection unit's name}
\item{ \code{colldate} }{date in collection unit}
\item{ \code{substrate} }{substrate}
\item{ \code{location} }{sf object that describes site's location}
\item{ \code{datasets} }{detailed information regarding dataset}
Each "dataset" nested in the "collection unit" contains the
following detail of information:
\item{ \code{datasetid} }{dataset ID number}
\item{ \code{datasetname} }{site's name}
\item{ \code{datasettype} }{type of data found}
\item{ \code{location} }{sf object that describes site's location}
\item{ \code{notes} }{notes on the dataset}
\item{ \code{taxa table} }{taxa table}
\item{ \code{pi list} }{P.I. info}
\item{ \code{analyst} }{analyst info}
\item{ \code{metadata} }{dataset metadata}
}
\description{
Information for Fossil Datasets
}
\details{
The \code{get_downloads()} command wraps the Neotoma API
(\href{https://api.neotomadb.org}{api.neotomadb.org}) call for \code{downloads}.
The call itself uses a SQL query which accepts any one of the following
parameters:
\itemize{
\item \code{datasetid} The unique dataset ID (integer) in Neotoma. Can be passed
as a vector of dataset IDs.
\item \code{all_data} The API only downloads the first 25 records of the query.
For the complete records, use \code{all_data=TRUE}
}
}
\examples{
\donttest{
# To find the downloads object of dataset 24:
downloads24 <- get_downloads(24)

# To find all downloads in Brazil
brazil <- '{"type": "Polygon",
"coordinates": [[
 [-73.125, -9.102096738726443],
 [-56.953125,-33.137551192346145],
 [-36.5625,-7.710991655433217],
 [-68.203125,13.923403897723347],
 [-73.125,-9.102096738726443]]]}'
brazil_datasets <- get_datasets(loc = brazil[1])
brazil_downloads <- get_downloads(brazil_datasets)
}
}
\author{
Socorro Dominguez \email{dominguezvid@wisc.edu}
}
