% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nestedRanksTest.R
\name{nestedRanksTest_Z}
\alias{nestedRanksTest_Z}
\title{Calculates Z-score from ranks.}
\usage{
nestedRanksTest_Z(y, n1, n2)
}
\arguments{
\item{y}{Values to be ranked for the test.  Its length must
be equal to the sum of \code{n1} and \code{n2}.}

\item{n1}{The first \code{n1} values in \code{y} belong to the
first treatment level.}

\item{n2}{The final \code{n2} values in \code{y} belong to the
            second treatment level.}
}
\value{
The calculated Z-score
}
\description{
\code{nestedRanksTest_Z} is used by \code{nestedRanksTest} to
calculate the Z-score for the ranks of responses \code{y} divided
into two treatment levels.
}
\details{
Values across both treatments are ranked using the base R function
\code{rank} with \code{ties.method = "average"}, which assigns
tied values their average rank.  The Mann-Whitney-Wilcoxon test
statistic is computed from these ranks.  Because the value of the
statistic is sample-size dependent (between \code{-n1*n2} and
\code{n1*n2}), it is scaled to be \code{[-1,+1]} by dividing by
\code{n1*n2}.

The bottleneck for bootstrapping is calculation of ranks, so the most
straightforward way to speed up \code{nestedRanksTest} would come from
speeding up \code{rank}.  Because of the checks performed prior to
calling this routine, it should be sufficient to use a stripped-down
function that simply does the equivalent of making an \code{.Internal}
call, which is not allowed within package code.  As of this writing, this
is sufficient:

\code{rank_new <- function (x) .Internal(rank(x, length(x), "average"))}

For the example data this is 8-9 times faster than the base R \code{rank},
because it avoids error-checking overhead.  For longer vectors, the
advantage decreases such that at 10000 elements it is 20-30\%.
}
\seealso{
\code{\link{nestedRanksTest}}, \code{\link{wilcox.test}}
}

