% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_filter.R
\name{boot_filter}
\alias{boot_filter}
\title{Bootstrap for filter functions}
\usage{
boot_filter(y, x, filterFUN, B = 50, nfilter = NULL, type = "index", ...)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{filterFUN}{Filter function, e.g. \code{\link[=ttest_filter]{ttest_filter()}}.}

\item{B}{Number of times to bootstrap}

\item{nfilter}{Number of predictors to return}

\item{type}{Type of vector returned. Default "index" returns indices, "full"
returns full output.}

\item{...}{Optional arguments passed to the function specified by \code{filterFUN}}
}
\value{
Integer vector of indices of filtered parameters (\code{type = "index"})
or if \code{type = "full"} a matrix of rankings from each bootstrap is returned.
}
\description{
Randomly samples predictors and averages the ranking to give an ensemble
measure of predictor variable importance.
}
\seealso{
\code{\link[=boot_ttest]{boot_ttest()}}
}
