% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{ttest_filter}
\alias{ttest_filter}
\title{t-test filter}
\usage{
ttest_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full"),
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{force_vars}{Vector of column names within \code{x} which are always retained
in the model (i.e. not filtered). Default \code{NULL} means all predictors will
be passed to \code{filterFUN}.}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors with
p-values < \code{p_cutoff} are returned.}

\item{p_cutoff}{p value cut-off}

\item{rsq_cutoff}{r^2 cutoff for removing predictors due to collinearity.
Default \code{NULL} means no collinearity filtering. Predictors are ranked based
on t-test. If 2 or more predictors are collinear, the first ranked
predictor by t-test is retained, while the other collinear predictors are
removed. See \code{\link[=collinear]{collinear()}}.}

\item{type}{Type of vector returned. Default "index" returns indices, "names"
returns predictor names, "full" returns a matrix of p values.}

\item{...}{optional arguments, e.g. \code{rsq_method}: see \code{\link[=collinear]{collinear()}}.}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters in order
of t-test p-value. If \code{type} is \code{"full"} full output from
\link[Rfast:ttests]{Rfast::ttests} is returned.
}
\description{
Simple univariate filter using t-test using the Rfast package for speed.
Can be applied to all or a subset of predictors.
}
\examples{
## sigmoid function
sigmoid <- function(x) {1 / (1 + exp(-x))}

## load iris dataset and simulate a binary outcome
data(iris)
dt <- iris[, 1:4]
colnames(dt) <- c("marker1", "marker2", "marker3", "marker4")
dt <- as.data.frame(apply(dt, 2, scale))
y2 <- sigmoid(0.5 * dt$marker1 + 2 * dt$marker2) > runif(nrow(dt))
y2 <- factor(y2, labels = c("C1", "C2"))

ttest_filter(y2, dt)  # returns index of filtered predictors
ttest_filter(y2, dt, type = "name")  # shows names of predictors
ttest_filter(y2, dt, type = "full")  # full results table

}
