% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettest.R
\name{make.permute.Phi}
\alias{make.permute.Phi}
\title{Permutation Test of \eqn{\Phi}}
\usage{
make.permute.Phi(A, Y, np)
}
\arguments{
\item{A}{\code{[n x n]} adjacency matrix or general relational weight matrix of which \eqn{A_ij} indicates relationship from \eqn{i} to \eqn{j}.}

\item{Y}{a vector of \eqn{n} continuous or binary, one-dimensional observations.}

\item{np}{the number of permutation samples.}
}
\value{
\item{\code{phi}}{a standardized \eqn{\Phi} statistic.}
\item{\code{pval.z}}{p-value of a standardized \eqn{\Phi} statistic assuming asymptotic normality.}
\item{\code{pval.permute}}{p-value of a standardized \eqn{\Phi} statistic using \code{np} independent permutation samples.}
}
\description{
This function prints out the network dependence test results for categorical observations.
}
\examples{
library(netdep)
library(igraph)
library(igraphdata)
data(UKfaculty)
A = as.matrix(get.adjacency(UKfaculty, attr= "weight", sparse = TRUE)) # weighted adjacency matrix
Y = V(UKfaculty)$Group
result = make.permute.Phi(A, Y, np = 50)


}
\author{
Youjin Lee
}
